/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.inlineparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiInlineParser;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiInlineParserCreator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class WikiInlineParserBase
implements WikiInlineParser {
    protected WikiEngine wikiEngine_;

    public WikiInlineParserBase(WikiEngine wikiEngine) {
        this.wikiEngine_ = wikiEngine;
    }

    @Override
    public String parse(String line) {
        String htmlString = line;
        if (!line.isEmpty() && !line.equals("{{#TOC}}")) {
            WikiInlineParserCreator creator = new WikiInlineParserCreator(this.wikiEngine_);
            StringBuffer buf = new StringBuffer("");
            String[] split = this.devideLine(line);
            buf.append(split[0]);
            String textNode = this.deleteWikiToken(split[1]);
            WikiInlineParser parser = creator.create(textNode);
            textNode = parser.parse(textNode);
            StringBuffer mainBuf = new StringBuffer();
            this.startElementProcess(mainBuf);
            this.textNodeProcess(mainBuf, textNode);
            this.endElementProcess(mainBuf);
            buf.append(mainBuf.toString());
            htmlString = buf.append(split[2]).toString();
            parser = creator.create(htmlString);
            StringBuffer buf2 = new StringBuffer("");
            buf2.append(parser.parse(htmlString));
            htmlString = buf2.toString();
        }
        return htmlString;
    }

    public abstract String deleteWikiToken(String var1);

    public abstract void startElementProcess(StringBuffer var1);

    public void textNodeProcess(StringBuffer buf, String textNode) {
        buf.append(textNode);
    }

    public abstract void endElementProcess(StringBuffer var1);

    public abstract String getStartPattern();

    public abstract String getEndPattern();

    @Override
    public String[] devideLine(String line) {
        String matchString = null;
        String[] result = null;
        Matcher startMatcher = Pattern.compile(this.getStartPattern()).matcher(line);
        if (startMatcher.find()) {
            String startSub = line.substring(startMatcher.start());
            Matcher endMatcher = Pattern.compile(this.getEndPattern()).matcher(startSub);
            matchString = endMatcher.find() ? startSub.substring(0, endMatcher.end()) : startSub;
        }
        if (matchString != null) {
            String[] split = line.split(Pattern.quote(matchString), 2);
            result = new String[]{split[0], matchString, split[1]};
        }
        return result;
    }
}

