/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.inlineparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiBoldInlineParser;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiDefaultInlineParser;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiExternalLinkInlineParser;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiInlineParser;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiInternalLinkInlineParser;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiItalicInlineParser;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiLineThroughInlineParser;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiOrderedListItemInlineParser;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiUnderlineInlineParser;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiUnorderedListItemInlineParser;
import java.util.ArrayList;

public class WikiInlineParserCreator {
    private ArrayList<Creator> creatorList_;
    private WikiEngine wikiEngine_;
    private static final ArrayList<Creator> defaultCreatorList_ = new ArrayList<Creator>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(new Creator(){

                @Override
                public boolean matches(String line) {
                    return WikiInternalLinkInlineParser.matches(line);
                }

                @Override
                public WikiInlineParser create(WikiEngine wikiEngine) {
                    return new WikiInternalLinkInlineParser(wikiEngine);
                }
            });
            this.add(new Creator(){

                @Override
                public boolean matches(String line) {
                    return WikiExternalLinkInlineParser.matches(line);
                }

                @Override
                public WikiInlineParser create(WikiEngine wikiEngine) {
                    return new WikiExternalLinkInlineParser(wikiEngine);
                }
            });
            this.add(new Creator(){

                @Override
                public boolean matches(String line) {
                    return WikiBoldInlineParser.matches(line.toLowerCase());
                }

                @Override
                public WikiInlineParser create(WikiEngine wikiEngine) {
                    return new WikiBoldInlineParser(wikiEngine);
                }
            });
            this.add(new Creator(){

                @Override
                public boolean matches(String line) {
                    return WikiItalicInlineParser.matches(line);
                }

                @Override
                public WikiInlineParser create(WikiEngine wikiEngine) {
                    return new WikiItalicInlineParser(wikiEngine);
                }
            });
            this.add(new Creator(){

                @Override
                public boolean matches(String line) {
                    return WikiUnderlineInlineParser.matches(line);
                }

                @Override
                public WikiInlineParser create(WikiEngine wikiEngine) {
                    return new WikiUnderlineInlineParser(wikiEngine);
                }
            });
            this.add(new Creator(){

                @Override
                public boolean matches(String line) {
                    return WikiLineThroughInlineParser.matches(line);
                }

                @Override
                public WikiInlineParser create(WikiEngine wikiEngine) {
                    return new WikiLineThroughInlineParser(wikiEngine);
                }
            });
            this.add(new Creator(){

                @Override
                public boolean matches(String line) {
                    return WikiUnorderedListItemInlineParser.matches(line);
                }

                @Override
                public WikiInlineParser create(WikiEngine wikiEngine) {
                    return new WikiUnorderedListItemInlineParser(wikiEngine);
                }
            });
            this.add(new Creator(){

                @Override
                public boolean matches(String line) {
                    return WikiOrderedListItemInlineParser.matches(line);
                }

                @Override
                public WikiInlineParser create(WikiEngine wikiEngine) {
                    return new WikiOrderedListItemInlineParser(wikiEngine);
                }
            });
        }
    };

    public WikiInlineParserCreator(WikiEngine wikiEngine) {
        this(defaultCreatorList_, wikiEngine);
    }

    public WikiInlineParserCreator(ArrayList<Creator> creatorList, WikiEngine wikiEngine) {
        this.creatorList_ = creatorList;
        this.wikiEngine_ = wikiEngine;
    }

    public WikiInlineParser create(String line) {
        WikiInlineParser parser = null;
        StringBuffer withoutElem = new StringBuffer("");
        if (!line.isEmpty() && line.contains("<") && line.contains(">")) {
            withoutElem.append(line.substring(0, line.indexOf("<")));
            withoutElem.append(line.substring(line.lastIndexOf(">") + ">".length()));
        } else {
            withoutElem.append(line);
        }
        if (!withoutElem.toString().isEmpty()) {
            for (Creator creator : this.creatorList_) {
                if (!creator.matches(withoutElem.toString())) continue;
                parser = creator.create(this.wikiEngine_);
                break;
            }
        }
        if (parser == null) {
            parser = new WikiDefaultInlineParser(this.wikiEngine_);
        }
        return parser;
    }

    public static interface Creator {
        public boolean matches(String var1);

        public WikiInlineParser create(WikiEngine var1);
    }
}

