/*
 * Decompiled with CFR 0.152.
 */
package com.wiki.standalone.moxkiriya.parser.inlineparser;

import com.wiki.standalone.moxkiriya.WikiEngine;
import com.wiki.standalone.moxkiriya.parser.inlineparser.WikiInlineParserBase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiUnderlineInlineParser
extends WikiInlineParserBase {
    public static final String WIKI_TOKEN = "__";
    public static final String PATTERN_START = "__[^_]";
    public static final String PATTERN_END = "[^_]__";
    private static final String START_TAG = "<span id=\"underline\">\n";
    private static final String END_TAG = "</span>\n";

    public WikiUnderlineInlineParser(WikiEngine wikiEngine) {
        super(wikiEngine);
    }

    public static boolean matches(String line) {
        boolean isMatch = false;
        Matcher startMatcher = Pattern.compile(PATTERN_START).matcher(line);
        if (startMatcher.find()) {
            int startIndex = startMatcher.start();
            String subline = line.substring(startIndex);
            Matcher underlineEndMatcher = Pattern.compile(PATTERN_END).matcher(subline);
            if (underlineEndMatcher.find()) {
                isMatch = true;
            }
        }
        return isMatch;
    }

    @Override
    public String deleteWikiToken(String line) {
        String deleteTop = line.replaceFirst(WIKI_TOKEN, "");
        return deleteTop.substring(0, deleteTop.lastIndexOf(WIKI_TOKEN));
    }

    @Override
    public void startElementProcess(StringBuffer buf) {
        buf.append(START_TAG);
    }

    @Override
    public void endElementProcess(StringBuffer buf) {
        buf.append(END_TAG);
    }

    @Override
    public String getStartPattern() {
        return PATTERN_START;
    }

    @Override
    public String getEndPattern() {
        return PATTERN_END;
    }
}

