/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.bundle;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.stats.RepositoryStatistics;
import org.apache.jackrabbit.core.cache.Cache;
import org.apache.jackrabbit.core.cache.CacheAccessListener;
import org.apache.jackrabbit.core.cache.ConcurrentCache;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.CachingPersistenceManager;
import org.apache.jackrabbit.core.persistence.IterablePersistenceManager;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.ConsistencyCheckerImpl;
import org.apache.jackrabbit.core.persistence.check.ConsistencyCheckListener;
import org.apache.jackrabbit.core.persistence.check.ConsistencyChecker;
import org.apache.jackrabbit.core.persistence.check.ConsistencyReport;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.FileBasedIndex;
import org.apache.jackrabbit.core.persistence.util.NodeInfo;
import org.apache.jackrabbit.core.persistence.util.NodePropBundle;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.util.StringIndex;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.stats.RepositoryStatisticsImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBundlePersistenceManager
implements PersistenceManager,
CachingPersistenceManager,
IterablePersistenceManager,
CacheAccessListener,
ConsistencyChecker {
    private static Logger auditLogger = LoggerFactory.getLogger("org.apache.jackrabbit.core.audit");
    private static Logger log = LoggerFactory.getLogger(AbstractBundlePersistenceManager.class);
    protected static final String NODEFILENAME = "n";
    protected static final String NODEREFSFILENAME = "r";
    protected static final String RES_NAME_INDEX = "/names.properties";
    protected static final String RES_NS_INDEX = "/namespaces.properties";
    private static final NodePropBundle MISSING = new NodePropBundle(NodeId.randomId());
    private static final long MISSING_SIZE_ESTIMATE = 128L;
    private StringIndex nsIndex;
    private StringIndex nameIndex;
    private ConcurrentCache<NodeId, NodePropBundle> bundles;
    private static final int DEFAULT_LOG_STATS_INTERVAL = 60000;
    private long minLogStatsInterval = Long.getLong("org.apache.jackrabbit.cacheLogStatsInterval", 60000L);
    private volatile long nextLogStats = System.currentTimeMillis() + 60000L;
    protected PMContext context;
    private long bundleCacheSize = 0x800000L;
    private AtomicLong readCounter;
    private AtomicLong writeCounter;
    private AtomicLong writeDuration;
    private AtomicLong cacheAccessCounter;
    private AtomicLong cacheMissCounter;
    private AtomicLong cacheMissDuration;
    private AtomicLong cacheSizeCounter;
    private UpdateEventChannel eventChannel;

    public String getBundleCacheSize() {
        return String.valueOf(this.bundleCacheSize / 0x100000L);
    }

    public void setBundleCacheSize(String bundleCacheSize) {
        this.bundleCacheSize = Long.parseLong(bundleCacheSize) * 1024L * 1024L;
    }

    protected StringBuffer buildNodeFolderPath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        char[] chars = id.toString().toCharArray();
        int cnt = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') continue;
            if (cnt == 2 || cnt == 4) {
                buf.append('/');
            }
            buf.append(chars[i]);
            ++cnt;
        }
        return buf;
    }

    protected StringBuffer buildPropFilePath(StringBuffer buf, PropertyId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id.getParentId());
        buf.append("/");
        buf.append(this.getNsIndex().stringToIndex(id.getName().getNamespaceURI()));
        buf.append('.');
        buf.append(this.getNameIndex().stringToIndex(id.getName().getLocalName()));
        return buf;
    }

    protected StringBuffer buildBlobFilePath(StringBuffer buf, PropertyId id, int i) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildPropFilePath(buf, id);
        buf.append('.');
        buf.append(i);
        return buf;
    }

    protected StringBuffer buildNodeFilePath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id);
        buf.append("/");
        buf.append(NODEFILENAME);
        return buf;
    }

    protected StringBuffer buildNodeReferencesFilePath(StringBuffer buf, NodeId id) {
        if (buf == null) {
            buf = new StringBuffer();
        }
        this.buildNodeFolderPath(buf, id);
        buf.append("/");
        buf.append(NODEREFSFILENAME);
        return buf;
    }

    public StringIndex getNsIndex() {
        try {
            if (this.nsIndex == null) {
                FileSystemResource nsFile = new FileSystemResource(this.context.getFileSystem(), RES_NS_INDEX);
                this.nsIndex = nsFile.exists() ? new FileBasedIndex(nsFile) : (StringIndex)((Object)this.context.getNamespaceRegistry());
            }
            return this.nsIndex;
        }
        catch (Exception e) {
            IllegalStateException e2 = new IllegalStateException("Unable to create nsIndex.");
            e2.initCause(e);
            throw e2;
        }
    }

    public StringIndex getNameIndex() {
        try {
            if (this.nameIndex == null) {
                this.nameIndex = new FileBasedIndex(new FileSystemResource(this.context.getFileSystem(), RES_NAME_INDEX));
            }
            return this.nameIndex;
        }
        catch (Exception e) {
            IllegalStateException e2 = new IllegalStateException("Unable to create nameIndex.");
            e2.initCause(e);
            throw e2;
        }
    }

    @Override
    public synchronized void onExternalUpdate(ChangeLog changes) {
        for (ItemState state : changes.modifiedStates()) {
            this.bundles.remove(this.getBundleId(state));
        }
        for (ItemState state : changes.deletedStates()) {
            this.bundles.remove(this.getBundleId(state));
        }
        for (ItemState state : changes.addedStates()) {
            this.bundles.remove(this.getBundleId(state));
        }
    }

    private NodeId getBundleId(ItemState state) {
        if (state.isNode()) {
            return (NodeId)state.getId();
        }
        return state.getParentId();
    }

    @Override
    public Map<NodeId, NodeInfo> getAllNodeInfos(NodeId after, int maxCount) throws ItemStateException, RepositoryException {
        LinkedHashMap<NodeId, NodeInfo> infos = new LinkedHashMap<NodeId, NodeInfo>();
        for (NodeId nodeId : this.getAllNodeIds(after, maxCount)) {
            infos.put(nodeId, new NodeInfo(this.loadBundle(nodeId)));
        }
        return infos;
    }

    protected abstract NodePropBundle loadBundle(NodeId var1) throws ItemStateException;

    protected abstract void storeBundle(NodePropBundle var1) throws ItemStateException;

    protected abstract void destroyBundle(NodePropBundle var1) throws ItemStateException;

    protected abstract void destroy(NodeReferences var1) throws ItemStateException;

    protected abstract void store(NodeReferences var1) throws ItemStateException;

    protected abstract BLOBStore getBlobStore();

    @Override
    public void init(PMContext context) throws Exception {
        this.context = context;
        this.bundles = new ConcurrentCache(context.getHomeDir().getName() + "BundleCache");
        this.bundles.setMaxMemorySize(this.bundleCacheSize);
        this.bundles.setAccessListener(this);
        RepositoryStatisticsImpl stats = context.getRepositoryStatistics();
        this.readCounter = stats.getCounter(RepositoryStatistics.Type.BUNDLE_READ_COUNTER);
        this.writeCounter = stats.getCounter(RepositoryStatistics.Type.BUNDLE_WRITE_COUNTER);
        this.writeDuration = stats.getCounter(RepositoryStatistics.Type.BUNDLE_WRITE_DURATION);
        this.cacheAccessCounter = stats.getCounter(RepositoryStatistics.Type.BUNDLE_CACHE_ACCESS_COUNTER);
        this.cacheSizeCounter = stats.getCounter(RepositoryStatistics.Type.BUNDLE_CACHE_SIZE_COUNTER);
        this.cacheMissCounter = stats.getCounter(RepositoryStatistics.Type.BUNDLE_CACHE_MISS_COUNTER);
        this.cacheMissDuration = stats.getCounter(RepositoryStatistics.Type.BUNDLE_CACHE_MISS_DURATION);
    }

    @Override
    public void close() throws Exception {
        this.bundles.clear();
    }

    @Override
    public NodeState load(NodeId id) throws NoSuchItemStateException, ItemStateException {
        NodePropBundle bundle = this.getBundle(id);
        if (bundle == null) {
            throw new NoSuchItemStateException(id.toString());
        }
        return bundle.createNodeState(this);
    }

    @Override
    public PropertyState load(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        NodePropBundle bundle = this.getBundle(id.getParentId());
        if (bundle != null) {
            PropertyState state = this.createNew(id);
            NodePropBundle.PropertyEntry p = bundle.getPropertyEntry(id.getName());
            if (p != null) {
                state.setMultiValued(p.isMultiValued());
                state.setType(p.getType());
                state.setValues(p.getValues());
                state.setModCount(p.getModCount());
            } else if (id.getName().equals(NameConstants.JCR_UUID)) {
                state.setType(1);
                state.setMultiValued(false);
                state.setValues(new InternalValue[]{InternalValue.create(id.getParentId().toString())});
            } else if (id.getName().equals(NameConstants.JCR_PRIMARYTYPE)) {
                state.setType(7);
                state.setMultiValued(false);
                state.setValues(new InternalValue[]{InternalValue.create(bundle.getNodeTypeName())});
            } else if (id.getName().equals(NameConstants.JCR_MIXINTYPES)) {
                state.setType(7);
                state.setMultiValued(true);
                Set<Name> mixins = bundle.getMixinTypeNames();
                state.setValues(InternalValue.create(mixins.toArray(new Name[mixins.size()])));
            } else {
                throw new NoSuchItemStateException(id.toString());
            }
            return state;
        }
        throw new NoSuchItemStateException(id.toString());
    }

    @Override
    public boolean exists(PropertyId id) throws ItemStateException {
        NodePropBundle bundle = this.getBundle(id.getParentId());
        if (bundle != null) {
            Name name = id.getName();
            return bundle.hasProperty(name) || NameConstants.JCR_PRIMARYTYPE.equals(name) || NameConstants.JCR_UUID.equals(name) && bundle.isReferenceable() || NameConstants.JCR_MIXINTYPES.equals(name) && !bundle.getMixinTypeNames().isEmpty();
        }
        return false;
    }

    @Override
    public boolean exists(NodeId id) throws ItemStateException {
        return this.getBundle(id) != null;
    }

    @Override
    public NodeState createNew(NodeId id) {
        return new NodeState(id, null, null, 4, false);
    }

    @Override
    public PropertyState createNew(PropertyId id) {
        return new PropertyState(id, 4, false);
    }

    @Override
    public synchronized void store(ChangeLog changeLog) throws ItemStateException {
        boolean success = false;
        try {
            this.storeInternal(changeLog);
            success = true;
        }
        finally {
            if (!success) {
                this.bundles.clear();
            }
        }
    }

    private void storeInternal(ChangeLog changeLog) throws ItemStateException {
        NodePropBundle bundle;
        NodeId nodeId;
        PropertyId id;
        HashSet<ItemId> deleted = new HashSet<ItemId>();
        for (ItemState itemState : changeLog.deletedStates()) {
            if (!itemState.isNode()) continue;
            NodePropBundle bundle2 = this.getBundle((NodeId)itemState.getId());
            if (bundle2 == null) {
                throw new NoSuchItemStateException(itemState.getId().toString());
            }
            this.deleteBundle(bundle2);
            deleted.add(itemState.getId());
        }
        HashMap<ItemId, NodePropBundle> modified = new HashMap<ItemId, NodePropBundle>();
        for (ItemState state : changeLog.addedStates()) {
            if (!state.isNode()) continue;
            NodePropBundle bundle3 = new NodePropBundle((NodeState)state);
            modified.put(state.getId(), bundle3);
        }
        for (ItemState state : changeLog.modifiedStates()) {
            if (state.isNode()) {
                NodeId nodeId2 = (NodeId)state.getId();
                NodePropBundle bundle4 = (NodePropBundle)modified.get(nodeId2);
                if (bundle4 == null) {
                    bundle4 = this.getBundle(nodeId2);
                    if (bundle4 == null) {
                        throw new NoSuchItemStateException(nodeId2.toString());
                    }
                    modified.put(nodeId2, bundle4);
                }
                bundle4.update((NodeState)state);
                continue;
            }
            id = (PropertyId)state.getId();
            if (id.getName().equals(NameConstants.JCR_PRIMARYTYPE) || id.getName().equals(NameConstants.JCR_UUID)) continue;
            nodeId = id.getParentId();
            bundle = (NodePropBundle)modified.get(nodeId);
            if (bundle == null) {
                bundle = this.getBundle(nodeId);
                if (bundle == null) {
                    throw new NoSuchItemStateException(nodeId.toString());
                }
                modified.put(nodeId, bundle);
            }
            bundle.addProperty((PropertyState)state, this.getBlobStore());
        }
        for (ItemState state : changeLog.deletedStates()) {
            if (state.isNode()) {
                NodeId parentId = state.getParentId();
                if (modified.containsKey(parentId) || deleted.contains(parentId)) continue;
                log.warn("Deleted node state's parent is not modified or deleted: " + parentId + "/" + state.getId());
                continue;
            }
            id = (PropertyId)state.getId();
            nodeId = id.getParentId();
            if (deleted.contains(nodeId)) continue;
            bundle = (NodePropBundle)modified.get(nodeId);
            if (bundle == null) {
                log.warn("deleted property state's parent not modified!");
                bundle = this.getBundle(nodeId);
                if (bundle == null) {
                    throw new NoSuchItemStateException(nodeId.toString());
                }
                modified.put(nodeId, bundle);
            }
            bundle.removeProperty(id.getName(), this.getBlobStore());
        }
        for (ItemState state : changeLog.addedStates()) {
            if (state.isNode() || (id = (PropertyId)state.getId()).getName().equals(NameConstants.JCR_PRIMARYTYPE) || id.getName().equals(NameConstants.JCR_UUID)) continue;
            nodeId = id.getParentId();
            bundle = (NodePropBundle)modified.get(nodeId);
            if (bundle == null) {
                log.warn("added property state's parent not modified!");
                bundle = this.getBundle(nodeId);
                if (bundle == null) {
                    throw new NoSuchItemStateException(nodeId.toString());
                }
                modified.put(nodeId, bundle);
            }
            bundle.addProperty((PropertyState)state, this.getBlobStore());
        }
        long l = 0L;
        for (NodePropBundle bundle2 : modified.values()) {
            this.putBundle(bundle2);
            l += bundle2.getSize();
        }
        changeLog.setUpdateSize(l);
        for (NodeReferences refs : changeLog.modifiedRefs()) {
            if (refs.hasReferences()) {
                this.store(refs);
                continue;
            }
            this.destroy(refs);
        }
    }

    private NodePropBundle getBundle(NodeId id) throws ItemStateException {
        NodePropBundle bundle = this.bundles.get(id);
        this.readCounter.incrementAndGet();
        if (bundle == MISSING) {
            return null;
        }
        if (bundle != null) {
            return bundle;
        }
        return this.getBundleCacheMiss(id);
    }

    private NodePropBundle getBundleCacheMiss(NodeId id) throws ItemStateException {
        long time = System.nanoTime();
        log.debug("Loading bundle {}", (Object)id);
        NodePropBundle bundle = this.loadBundle(id);
        this.cacheMissDuration.addAndGet(System.nanoTime() - time);
        this.cacheMissCounter.incrementAndGet();
        if (bundle != null) {
            bundle.markOld();
            this.bundles.put(id, bundle, bundle.getSize());
        } else {
            this.bundles.put(id, MISSING, 128L);
        }
        return bundle;
    }

    private void deleteBundle(NodePropBundle bundle) throws ItemStateException {
        this.destroyBundle(bundle);
        bundle.removeAllProperties(this.getBlobStore());
        this.bundles.put(bundle.getId(), MISSING, 128L);
    }

    private void putBundle(NodePropBundle bundle) throws ItemStateException {
        long time = System.nanoTime();
        log.debug("Storing bundle {}", (Object)bundle.getId());
        this.storeBundle(bundle);
        if (auditLogger.isDebugEnabled()) {
            auditLogger.debug("{} ({})", (Object)bundle.getId(), (Object)bundle.getSize());
        }
        this.writeDuration.addAndGet(System.nanoTime() - time);
        this.writeCounter.incrementAndGet();
        bundle.markOld();
        if (this.bundles.containsKey(bundle.getId())) {
            this.bundles.put(bundle.getId(), bundle, bundle.getSize());
        }
    }

    @Override
    public void checkConsistency(String[] uuids, boolean recursive, boolean fix) {
        try {
            ConsistencyCheckerImpl checker = new ConsistencyCheckerImpl(this, null, null, this.eventChannel);
            checker.check(uuids, recursive);
            checker.doubleCheckErrors();
            if (fix) {
                checker.repair();
            }
        }
        catch (RepositoryException ex) {
            log.error("While running consistency check.", ex);
        }
    }

    @Override
    public void setEventChannel(UpdateEventChannel eventChannel) {
        this.eventChannel = eventChannel;
    }

    @Override
    public ConsistencyReport check(String[] uuids, boolean recursive, boolean fix, String lostNFoundId, ConsistencyCheckListener listener) throws RepositoryException {
        ConsistencyCheckerImpl checker = new ConsistencyCheckerImpl(this, listener, lostNFoundId, this.eventChannel);
        checker.check(uuids, recursive);
        checker.doubleCheckErrors();
        if (fix) {
            checker.repair();
        }
        return checker.getReport();
    }

    protected void evictBundle(NodeId id) {
        this.bundles.remove(id);
    }

    @Override
    public void cacheAccessed(long accessCount) {
        this.logCacheStats();
        this.cacheAccessCounter.addAndGet(accessCount);
        this.cacheSizeCounter.set(this.bundles.getMemoryUsed());
    }

    private void logCacheStats() {
        if (log.isInfoEnabled()) {
            long now = System.currentTimeMillis();
            if (now < this.nextLogStats) {
                return;
            }
            log.info(this.bundles.getCacheInfoAsString());
            this.nextLogStats = now + this.minLogStatsInterval;
        }
    }

    @Override
    public void disposeCache(Cache cache) {
    }
}

