/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;

public class SimpleQueryResult
implements QueryResult {
    private final String[] columnNames;
    private final String[] selectorNames;
    private RowIterator rowIterator;

    protected SimpleQueryResult(String[] columnNames, String[] selectorNames, RowIterator rowIterator) {
        assert (columnNames != null);
        assert (selectorNames != null && selectorNames.length >= 1);
        assert (rowIterator != null);
        this.columnNames = columnNames;
        this.selectorNames = selectorNames;
        this.rowIterator = rowIterator;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public String[] getSelectorNames() {
        return this.selectorNames;
    }

    @Override
    public synchronized RowIterator getRows() throws RepositoryException {
        if (this.rowIterator != null) {
            RowIterator iterator = this.rowIterator;
            this.rowIterator = null;
            return iterator;
        }
        throw new RepositoryException("This query result has already been iterated through");
    }

    @Override
    public NodeIterator getNodes() throws RepositoryException {
        if (this.selectorNames.length == 1) {
            return new NodeIteratorAdapter(this.getRows()){

                @Override
                public Object next() {
                    Row row = (Row)super.next();
                    try {
                        return row.getNode();
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException("Unable to access the node in " + row, e);
                    }
                }
            };
        }
        throw new RepositoryException("This query result contains more than one selector");
    }
}

