/*
mpaligner is program to align string and string.
Copyright (C) 2010, 2011 Keigo Kubo

mpaligner is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

mpaligner is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mpaligner.  If not, see <http://www.gnu.org/licenses/>.

Imprement algorithm and data structure for co-occurance parameter (COP)
date:   2010/9/16
author: Keigo Kubo
belong: Nara Institute Sience and Technology (NAIST)
e-mail: keigo-k{@}is.naist.jp   << Please transform {@} into @
*/

#include "COP_HASH.h"

static COP_HASH_VALUE COP_ROW_HASH_SIZE;
static COP_HASH_VALUE COP_COL_HASH_SIZE;

void COP_init(COP_HASH_VALUE row, COP_HASH_VALUE col){
	COP_HASH_VALUE i,j;

	COP_ROW_HASH_SIZE=row;
	COP_COL_HASH_SIZE=col;
	COP_TABLE=(COP ***)malloc(row*sizeof(COP **)+row*col*sizeof(COP *));
	for(i=0;i<row;i++){
		COP_TABLE[i]=(COP **)malloc(col*sizeof(COP *));
		for(j=0;j<col;j++){
			COP_TABLE[i][j]=NULL;
		}
	}
}

void COP_init_refer_count(){
	COP *p;
	COP_HASH_VALUE i,j;
	for(i=0;i<COP_ROW_HASH_SIZE;i++){
		for(j=0;j<COP_COL_HASH_SIZE;j++){
			for(p=COP_TABLE[i][j];p!=NULL;p=p->next){
				p->update_or_refer.refer_count=0;
			}
		}
	}
}

void COP_destroy(){
	COP *p;
	COP_HASH_VALUE i,j;
	for(i=0;i<COP_ROW_HASH_SIZE;i++){
		for(j=0;j<COP_COL_HASH_SIZE;j++){
			for(p=COP_TABLE[i][j];p!=NULL;p=COP_TABLE[i][j]){
				COP_TABLE[i][j]=p->next;
				free(p);
			}
		}
		free(COP_TABLE[i]);
	}
	free(COP_TABLE);
}

static COP **COP_hash_len(char *target_x, LEN target_x_len,
			 char *target_y, LEN target_y_len){
	COP **p;
	COP_HASH_VALUE value=0;
	char c;
	while(target_x_len--){
		while(c=*target_x++){
			value +=  (c * c) * (255 << target_x_len );
		}
		value/=7;
	}
	p=COP_TABLE[value%COP_ROW_HASH_SIZE];

	value=0;
	while(target_y_len--){
		while(c=*target_y++){
			value += (c * c) * (255 << target_y_len ); 
		}
		value/=7;
	}

	return &(p[value%COP_COL_HASH_SIZE]);
}

static int COP_keyequal_len(char *x,char *y, char *target_x, LEN target_x_len,
				char *target_y, LEN target_y_len){
	char c;
	while(target_x_len--){
		while(c=*target_x++){
			if(*x++!=c){
				return 0;
			}
		}
		x++;
	}

	if(*(--x)!='\0'){
		return 0;
	}

	while(target_y_len--){
		while(c=*target_y++){
			if(*y++!=c){
				return 0;
			}
		}
		y++;
	}

	if(*(--y)!='\0'){
		return 0;
	}

	return 1;
}

Parameter COP_refer_para(char *target_x, LEN target_x_len,
			 char *target_y, LEN target_y_len){
	COP **pp=COP_hash_len(target_x, target_x_len, target_y, target_y_len);
	COP *p=*pp;

	//search co-occurrence parameter node
	for(;p!=NULL;p=p->next){
		if(COP_keyequal_len(p->x, p->y, target_x, target_x_len,
						 target_y, target_y_len)){
			return p->para;
		}
	}

	return 0;
}

COP *COP_get(char *target_x, LEN target_x_len,
		 char *target_y, LEN target_y_len){
	COP **pp=COP_hash_len(target_x, target_x_len, target_y, target_y_len);
	COP *p=*pp;

	char c;
	LEN i,byte_x=0,byte_y=0;

	//search co-occurrence parameter node
	for(;p!=NULL;p=p->next){
		if(COP_keyequal_len(p->x, p->y, target_x, target_x_len,
						 target_y, target_y_len)){
			return p;
		}
	}

	//generate new co-occurrence parameter node

	for(i=0;i<target_x_len;i++){
		byte_x+=strlen(&target_x[byte_x+i]);
	}
	byte_x+=target_x_len;

	for(i=0;i<target_y_len;i++){
		byte_y+=strlen(&target_y[byte_y+i]);
	}
	byte_y+=target_y_len;

	if((p=(COP *)malloc(sizeof(COP)+byte_x+byte_y)) == NULL) {
		fprintf(stderr,"Don't get memory in malloc.\nYou must need more memory.\n");
		exit(EXIT_FAILURE);
	}

	p->next=*pp;
	*pp=p;

	p->x=(char *)(p+1);
	i=0;
	while(target_x_len--){
		while(c=*target_x++){
			p->x[i++]=c;
		}
		p->x[i++]=0x1f; // 0x1f is Unit Separator
	}
	p->x[--i]='\0';

	p->y=&(p->x[++i]);
	i=0;
	while(target_y_len--){
		while(c=*target_y++){
			p->y[i++]=c;
		}
		p->y[i++]=0x1f; // 0x1f is Unit Separator
	}
	p->y[--i]='\0';

	p->para=0;
	p->update_or_refer.update_para=LOW_LOG_VALUE;
	//num_of_cop++;
	return p;
}

COP *COP_refer(char *target_x, LEN target_x_len,
		char *target_y, LEN target_y_len){
	COP **pp=COP_hash_len(target_x, target_x_len, target_y, target_y_len);
	COP *p=*pp;

	//search co-occurrence parameter node
	for(;p!=NULL;p=p->next){
		if(COP_keyequal_len(p->x, p->y, target_x, target_x_len,
						target_y, target_y_len)){
			return p;
		}
	}
	return NULL;
}

