/*
mpaligner is program to align string and string.
Copyright (C) 2010, 2011 Keigo Kubo

mpaligner is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

mpaligner is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mpaligner.  If not, see <http://www.gnu.org/licenses/>.

Define data structure for co-occurance parameter (COP)
date:   2010/9/16
author: Keigo Kubo
belong: Nara Institute Sience and Technology (NAIST)
e-mail: keigo-k{@}is.naist.jp   << Please transform {@} into @
*/

#ifndef _INCLUDE_COP_HASH_
#define _INCLUDE_COP_HASH_

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

typedef unsigned int COP_HASH_VALUE;
typedef short LEN;
typedef float Parameter;
#define LOW_LOG_VALUE -1.0e+8

typedef struct cop{
	char *x;
	char *y;

	Parameter para;
	union{
		Parameter update_para;
		unsigned int refer_count;
	} update_or_refer;
	struct cop *next;
} COP;

COP ***COP_TABLE;

void COP_init(COP_HASH_VALUE row, COP_HASH_VALUE col);
void COP_init_refer_count();
void COP_destroy();   

Parameter COP_refer_para(char *target_x, LEN target_x_len,
						 char *target_y, LEN target_y_len);

COP *COP_get(char *target_x, LEN target_x_len,
			 char *target_y, LEN target_y_len);

COP *COP_refer(char *target_x, LEN target_x_len,
				char *target_y, LEN target_y_len);

#endif
