/*
mpaligner is program to align string and string.
Copyright (C) 2010, 2011 Keigo Kubo

mpaligner is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
any later version.

mpaligner is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mpaligner.  If not, see <http://www.gnu.org/licenses/>.

Define data structure of mnimum pattern alignment
date:   2010/9/16
author: Keigo Kubo
belong: Nara Institute Sience and Technology (NAIST)
e-mail: keigo-k{@}is.naist.jp   << Please transform {@} into @
*/

#ifndef _INCLUDE_MPAlign_
#define _INCLUDE_MPAlign_

#include "COP_HASH.h"
#define INV_LOG_TEN 0.434294482
#define CMP_VITERBI_HYP(vh1,vh2) (vh1.score>(vh2.score-1.0e-6) && (vh1.num_of_trans < vh2.num_of_trans || (vh1.score-1.0e-6)>vh2.score))?(1):(0)

typedef struct Pair_Data{
	char **x_part_strs;
	char **y_part_strs;
	LEN x_size;
	LEN y_size;
	struct Pair_Data *next;
} PAIR_DATA;

typedef struct Viterbi_Hyp{
	LEN backX;
	LEN backY;
	struct Viterbi_Hyp *prev;
	LEN num_of_trans;
	Parameter score;
} VITERBI_HYP;

typedef struct Viterbi_Hyp_List{
	float inv_total_len;
	char rank_size;
	VITERBI_HYP *viterbi_hyp;
	struct Viterbi_Hyp_List *next;
} VITERBI_HYP_LIST;

typedef struct Align_Hyp{
	COP **cop;
	Parameter score;
} ALIGN_HYP;

typedef struct total_info{
	char *input_file;
	char *output_file;
	char *previous_knowledge_file;
	char *input_align_file;
	char *output_align_file;

	char printScore;

	COP_HASH_VALUE hash_size;
	COP_HASH_VALUE sqrt_hash_size;

	PAIR_DATA *pair_data;
	char delX; // allow deletion X
	char delY; // allow deletion Y
	float del_penalty;
	LEN restrictX; // restrict length of part string X
	LEN restrictY; // restrict length of part string Y
	LEN maxX; // max length of X
	LEN maxY; // max length of Y
	LEN maxLEN; // maximum length
	char input_sepchar; // separate char of input file
	char output_sepchar; // separate char of output file
	char output_joinchar; // join char of output file
	char *del_char; // deletion char

	Parameter total_update; // total of update value by training
	Parameter total_change; // total of change value by training
	Parameter lowest_para; // lowest value of para

	float threshold_eot; // Threshold for the end of the training

	char double_alignment;

	char first_n_best;
	char second_n_best;
} TOTAL_INFO;

void readInputFile(TOTAL_INFO *info);
void readPreviousKnowledge(TOTAL_INFO *info);
void readAlignFromFile(TOTAL_INFO *info);
void training(TOTAL_INFO *info);
void writeAlignToFile(TOTAL_INFO *info);

void requireAlignments(TOTAL_INFO *info);

#endif
