/*
 * Created on 2004/09/18
 */
package jp.sourceforge.mrsp;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/**
 * 
 * @author Ryuzo Yamamoto
 * @version $Id: MavenRepoSearchPlugin.java,v 1.1 2004/09/21 09:16:20 dragon3
 *          Exp $
 */
public class MavenRepoSearchPlugin extends AbstractUIPlugin {

    public static final String PLUGIN_ID = "jp.sourceforge.mrsp";

    private static final String RESOURCE = PLUGIN_ID + ".resources";

    private static MavenRepoSearchPlugin plugin;

    private ResourceBundle resourceBundle;

    /**
     * The constructor.
     */
    public MavenRepoSearchPlugin() {
        super();
        plugin = this;
        try {
            resourceBundle = ResourceBundle.getBundle(RESOURCE, Locale
                    .getDefault(), plugin.getClass().getClassLoader());
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    /**
     * Returns the shared instance.
     */
    public static MavenRepoSearchPlugin getDefault() {
        return plugin;
    }

    /**
     * Returns the string from the plugin's resource bundle, or 'key' if not
     * found.
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = MavenRepoSearchPlugin.getDefault()
                .getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    public static void log(Exception e) {
        IStatus status;
        if (e instanceof CoreException) {
            status = ((CoreException) e).getStatus();
        } else {
            status = new Status(IStatus.ERROR, PLUGIN_ID, IStatus.OK, e
                    .getMessage(), e);
        }
        plugin.getLog().log(status);
    }

    /**
     * Returns the plugin's resource bundle,
     */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

}