/*
 * Created on 2004/09/19
 */
package jp.sourceforge.mrsp.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;

import jp.sourceforge.mrsp.parser.ParseException;
import jp.sourceforge.mrsp.parser.XMLResponseParser;

/**
 * @author Ryuzo Yamamoto
 * @version $Id: RepoSearchServiceImpl.java,v 1.1 2004/09/20 10:49:16 yamamoto
 *          Exp $
 */
public class RepoSearchServiceImpl implements RepoSearchService {

    private static final String REPO_SEARCH_URL = "http://maven.ozacc.com/search?format=xml&keyword=";

    /*
     * (non-Javadoc)
     * 
     * @see jp.loveopium.eclipse.mrs.service.RepoSearchService#searchArtifactByKeyword(java.lang.String)
     */
    public List searchArtifactByKeyword(String keyword)
            throws RepoSearchServiceException {
        HttpURLConnection conn = null;
        BufferedReader br = null;
        try {
            String url = REPO_SEARCH_URL + URLEncoder.encode(keyword, "UTF-8");
            conn = (HttpURLConnection) new URL(url).openConnection();
            conn.connect();
            InputStream is = conn.getInputStream();
            br = new BufferedReader(new InputStreamReader(is));

            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            //            return new HtmlResponseParser().parse(sb.toString());
            return new XMLResponseParser().parse(sb.toString());

        } catch (MalformedURLException e) {
            throw new RepoSearchServiceException(e);
        } catch (IOException e) {
            throw new RepoSearchServiceException(e);
        } catch (ParseException e) {
            throw new RepoSearchServiceException(e);
        } finally {
            if (br != null) {
                try {
                    br.close();
                } catch (IOException e) {
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }

    }

}