/*
 * Created on 2004/09/21
 */
package jp.sourceforge.mrsp.util;

import jp.sourceforge.mrsp.model.Artifact;

/**
 * @author Ryuzo Yamamoto
 * @version $Id: MavenDependencyTagMaker.java,v 1.2 2004/09/22 02:39:38 dragon3 Exp $
 */
public class MavenDependencyTagMaker {

    private static final String LINE_SEPARATOR = System
            .getProperty("line.separator");

    private MavenDependencyTagMaker() {
    }

    public static final String create(Artifact artifact) {
        StringBuffer sb = new StringBuffer();

        sb.append("<dependency>").append(LINE_SEPARATOR);

        sb.append("  <groupId>").append(artifact.getGroupId()).append(
                "</groupId>").append(LINE_SEPARATOR);
        sb.append("  <artifactId>").append(artifact.getArtifactId()).append(
                "</artifactId>").append(LINE_SEPARATOR);
        sb.append("  <version>").append(artifact.getVersion()).append(
                "</version>").append(LINE_SEPARATOR);
        if (!artifact.getType().equals("jar")) {
            sb.append("  <type>").append(artifact.getType()).append("</type>")
                    .append(LINE_SEPARATOR);
        }
        sb.append("</dependency>").append(LINE_SEPARATOR);

        return sb.toString();
    }
}