//
// MessagePack for C++ static resolution routine
//
// Copyright (C) 2008-2009 FURUHASHI Sadayuki
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
//
#ifndef MSGPACK_TYPE_TUPLE_HPP__
#define MSGPACK_TYPE_TUPLE_HPP__

#include "msgpack/object.hpp"

namespace msgpack {

namespace type {

// FIXME operator==
// FIXME operator!=


template <typename A0 = void, typename A1 = void, typename A2 = void, typename A3 = void, typename A4 = void, typename A5 = void, typename A6 = void, typename A7 = void, typename A8 = void, typename A9 = void, typename A10 = void, typename A11 = void, typename A12 = void, typename A13 = void, typename A14 = void, typename A15 = void, typename A16 = void>
struct tuple;

template <typename Tuple, int N>
struct tuple_element;

template <typename Tuple, int N>
struct const_tuple_element;

template <typename T>
struct tuple_type {
	typedef T type;
	typedef T value_type;
	typedef T& reference;
	typedef const T& const_reference;
	typedef const T& transparent_reference;
};

template <typename T>
struct tuple_type<T&> {
	typedef T type;
	typedef T& value_type;
	typedef T& reference;
	typedef const T& const_reference;
	typedef T& transparent_reference;
};

template <typename T>
struct tuple_type<const T&> {
	typedef T type;
	typedef T& value_type;
	typedef T& reference;
	typedef const T& const_reference;
	typedef const T& transparent_reference;
};




template <typename A0>
struct tuple_element<tuple<A0>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0>& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};



template <typename A0, typename A1>
struct tuple_element<tuple<A0, A1>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1>
struct tuple_element<tuple<A0, A1>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};



template <typename A0, typename A1, typename A2>
struct tuple_element<tuple<A0, A1, A2>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2>
struct tuple_element<tuple<A0, A1, A2>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2>
struct tuple_element<tuple<A0, A1, A2>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple_element<tuple<A0, A1, A2, A3>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple_element<tuple<A0, A1, A2, A3, A4>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 0> : tuple_type<A0> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a0) {}
	typename tuple_type<A0>::reference get() { return _x; }
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 1> : tuple_type<A1> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a1) {}
	typename tuple_type<A1>::reference get() { return _x; }
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 2> : tuple_type<A2> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a2) {}
	typename tuple_type<A2>::reference get() { return _x; }
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 3> : tuple_type<A3> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a3) {}
	typename tuple_type<A3>::reference get() { return _x; }
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 4> : tuple_type<A4> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a4) {}
	typename tuple_type<A4>::reference get() { return _x; }
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 5> : tuple_type<A5> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a5) {}
	typename tuple_type<A5>::reference get() { return _x; }
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 6> : tuple_type<A6> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a6) {}
	typename tuple_type<A6>::reference get() { return _x; }
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 7> : tuple_type<A7> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a7) {}
	typename tuple_type<A7>::reference get() { return _x; }
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 8> : tuple_type<A8> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a8) {}
	typename tuple_type<A8>::reference get() { return _x; }
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 9> : tuple_type<A9> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a9) {}
	typename tuple_type<A9>::reference get() { return _x; }
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 10> : tuple_type<A10> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a10) {}
	typename tuple_type<A10>::reference get() { return _x; }
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 11> : tuple_type<A11> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a11) {}
	typename tuple_type<A11>::reference get() { return _x; }
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 12> : tuple_type<A12> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a12) {}
	typename tuple_type<A12>::reference get() { return _x; }
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 13> : tuple_type<A13> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a13) {}
	typename tuple_type<A13>::reference get() { return _x; }
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 14> : tuple_type<A14> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a14) {}
	typename tuple_type<A14>::reference get() { return _x; }
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 15> : tuple_type<A15> {
	tuple_element(tuple<A0, A1 , A2 , A3 , A4 , A5 , A6 , A7 , A8 , A9 , A10 , A11 , A12 , A13 , A14 , A15 >& x) : _x(x.a15) {}
	typename tuple_type<A15>::reference get() { return _x; }
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::reference _x;
};






template <typename A0>
struct const_tuple_element<tuple<A0>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};



template <typename A0, typename A1>
struct const_tuple_element<tuple<A0, A1>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1>
struct const_tuple_element<tuple<A0, A1>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};



template <typename A0, typename A1, typename A2>
struct const_tuple_element<tuple<A0, A1, A2>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2>
struct const_tuple_element<tuple<A0, A1, A2>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2>
struct const_tuple_element<tuple<A0, A1, A2>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3>
struct const_tuple_element<tuple<A0, A1, A2, A3>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};



template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 0> : tuple_type<A0> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a0) {}
	typename tuple_type<A0>::const_reference get() const { return _x; }
private:
	typename tuple_type<A0>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 1> : tuple_type<A1> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a1) {}
	typename tuple_type<A1>::const_reference get() const { return _x; }
private:
	typename tuple_type<A1>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 2> : tuple_type<A2> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a2) {}
	typename tuple_type<A2>::const_reference get() const { return _x; }
private:
	typename tuple_type<A2>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 3> : tuple_type<A3> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a3) {}
	typename tuple_type<A3>::const_reference get() const { return _x; }
private:
	typename tuple_type<A3>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 4> : tuple_type<A4> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a4) {}
	typename tuple_type<A4>::const_reference get() const { return _x; }
private:
	typename tuple_type<A4>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 5> : tuple_type<A5> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a5) {}
	typename tuple_type<A5>::const_reference get() const { return _x; }
private:
	typename tuple_type<A5>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 6> : tuple_type<A6> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a6) {}
	typename tuple_type<A6>::const_reference get() const { return _x; }
private:
	typename tuple_type<A6>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 7> : tuple_type<A7> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a7) {}
	typename tuple_type<A7>::const_reference get() const { return _x; }
private:
	typename tuple_type<A7>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 8> : tuple_type<A8> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a8) {}
	typename tuple_type<A8>::const_reference get() const { return _x; }
private:
	typename tuple_type<A8>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 9> : tuple_type<A9> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a9) {}
	typename tuple_type<A9>::const_reference get() const { return _x; }
private:
	typename tuple_type<A9>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 10> : tuple_type<A10> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a10) {}
	typename tuple_type<A10>::const_reference get() const { return _x; }
private:
	typename tuple_type<A10>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 11> : tuple_type<A11> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a11) {}
	typename tuple_type<A11>::const_reference get() const { return _x; }
private:
	typename tuple_type<A11>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 12> : tuple_type<A12> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a12) {}
	typename tuple_type<A12>::const_reference get() const { return _x; }
private:
	typename tuple_type<A12>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 13> : tuple_type<A13> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a13) {}
	typename tuple_type<A13>::const_reference get() const { return _x; }
private:
	typename tuple_type<A13>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 14> : tuple_type<A14> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a14) {}
	typename tuple_type<A14>::const_reference get() const { return _x; }
private:
	typename tuple_type<A14>::const_reference _x;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct const_tuple_element<tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>, 15> : tuple_type<A15> {
	const_tuple_element(const tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& x) : _x(x.a15) {}
	typename tuple_type<A15>::const_reference get() const { return _x; }
private:
	typename tuple_type<A15>::const_reference _x;
};





template <typename A0>
tuple<A0> make_tuple(typename tuple_type<A0>::transparent_reference a0)
{
	return tuple<A0>(a0);
}

template <typename A0, typename A1>
tuple<A0, A1> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1)
{
	return tuple<A0, A1>(a0, a1);
}

template <typename A0, typename A1, typename A2>
tuple<A0, A1, A2> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2)
{
	return tuple<A0, A1, A2>(a0, a1, a2);
}

template <typename A0, typename A1, typename A2, typename A3>
tuple<A0, A1, A2, A3> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3)
{
	return tuple<A0, A1, A2, A3>(a0, a1, a2, a3);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4>
tuple<A0, A1, A2, A3, A4> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4)
{
	return tuple<A0, A1, A2, A3, A4>(a0, a1, a2, a3, a4);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
tuple<A0, A1, A2, A3, A4, A5> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5)
{
	return tuple<A0, A1, A2, A3, A4, A5>(a0, a1, a2, a3, a4, a5);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
tuple<A0, A1, A2, A3, A4, A5, A6> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6>(a0, a1, a2, a3, a4, a5, a6);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
tuple<A0, A1, A2, A3, A4, A5, A6, A7> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7>(a0, a1, a2, a3, a4, a5, a6, a7);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>(a0, a1, a2, a3, a4, a5, a6, a7, a8);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14);
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> make_tuple(typename tuple_type<A0>::transparent_reference a0, typename tuple_type<A1>::transparent_reference a1, typename tuple_type<A2>::transparent_reference a2, typename tuple_type<A3>::transparent_reference a3, typename tuple_type<A4>::transparent_reference a4, typename tuple_type<A5>::transparent_reference a5, typename tuple_type<A6>::transparent_reference a6, typename tuple_type<A7>::transparent_reference a7, typename tuple_type<A8>::transparent_reference a8, typename tuple_type<A9>::transparent_reference a9, typename tuple_type<A10>::transparent_reference a10, typename tuple_type<A11>::transparent_reference a11, typename tuple_type<A12>::transparent_reference a12, typename tuple_type<A13>::transparent_reference a13, typename tuple_type<A14>::transparent_reference a14, typename tuple_type<A15>::transparent_reference a15)
{
	return tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15);
}



template <>
struct tuple<> {
};

template <typename A0>
struct tuple<A0> {
	typedef tuple<A0> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0) :
		a0(_a0) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
};

template <typename A0, typename A1>
struct tuple<A0, A1> {
	typedef tuple<A0, A1> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1) :
		a0(_a0), a1(_a1) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
};

template <typename A0, typename A1, typename A2>
struct tuple<A0, A1, A2> {
	typedef tuple<A0, A1, A2> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2) :
		a0(_a0), a1(_a1), a2(_a2) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
};

template <typename A0, typename A1, typename A2, typename A3>
struct tuple<A0, A1, A2, A3> {
	typedef tuple<A0, A1, A2, A3> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4>
struct tuple<A0, A1, A2, A3, A4> {
	typedef tuple<A0, A1, A2, A3, A4> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
struct tuple<A0, A1, A2, A3, A4, A5> {
	typedef tuple<A0, A1, A2, A3, A4, A5> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
struct tuple<A0, A1, A2, A3, A4, A5, A6> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
};

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
struct tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> {
	typedef tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15> value_type;
	tuple() {}
	tuple(typename tuple_type<A0>::transparent_reference _a0, typename tuple_type<A1>::transparent_reference _a1, typename tuple_type<A2>::transparent_reference _a2, typename tuple_type<A3>::transparent_reference _a3, typename tuple_type<A4>::transparent_reference _a4, typename tuple_type<A5>::transparent_reference _a5, typename tuple_type<A6>::transparent_reference _a6, typename tuple_type<A7>::transparent_reference _a7, typename tuple_type<A8>::transparent_reference _a8, typename tuple_type<A9>::transparent_reference _a9, typename tuple_type<A10>::transparent_reference _a10, typename tuple_type<A11>::transparent_reference _a11, typename tuple_type<A12>::transparent_reference _a12, typename tuple_type<A13>::transparent_reference _a13, typename tuple_type<A14>::transparent_reference _a14, typename tuple_type<A15>::transparent_reference _a15) :
		a0(_a0), a1(_a1), a2(_a2), a3(_a3), a4(_a4), a5(_a5), a6(_a6), a7(_a7), a8(_a8), a9(_a9), a10(_a10), a11(_a11), a12(_a12), a13(_a13), a14(_a14), a15(_a15) {}
	tuple(object o) { o.convert(this); }
	template <int N> typename tuple_element<value_type, N>::reference get()
		{ return tuple_element<value_type, N>(*this).get(); }
	template <int N> typename const_tuple_element<value_type, N>::const_reference get() const
		{ return const_tuple_element<value_type, N>(*this).get(); }
	
	A0 a0;
	A1 a1;
	A2 a2;
	A3 a3;
	A4 a4;
	A5 a5;
	A6 a6;
	A7 a7;
	A8 a8;
	A9 a9;
	A10 a10;
	A11 a11;
	A12 a12;
	A13 a13;
	A14 a14;
	A15 a15;
};


}  // namespace type


inline type::tuple<>& operator>> (
		object o,
		type::tuple<>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	return v;
}

template <typename A0>
type::tuple<A0>& operator>> (
		object o,
		type::tuple<A0>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 1) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	return v;
}

template <typename A0, typename A1>
type::tuple<A0, A1>& operator>> (
		object o,
		type::tuple<A0, A1>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 2) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	return v;
}

template <typename A0, typename A1, typename A2>
type::tuple<A0, A1, A2>& operator>> (
		object o,
		type::tuple<A0, A1, A2>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 3) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3>
type::tuple<A0, A1, A2, A3>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 4) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4>
type::tuple<A0, A1, A2, A3, A4>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 5) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
type::tuple<A0, A1, A2, A3, A4, A5>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 6) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
type::tuple<A0, A1, A2, A3, A4, A5, A6>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 7) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 8) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 9) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 10) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 11) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 12) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 13) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 14) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 15) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	return v;
}

template <typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& operator>> (
		object o,
		type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& v) {
	if(o.type != type::ARRAY) { throw type_error(); }
	if(o.via.array.size < 16) { throw type_error(); }
	
	o.via.array.ptr[0].convert<A0>(&v.template get<0>());
	o.via.array.ptr[1].convert<A1>(&v.template get<1>());
	o.via.array.ptr[2].convert<A2>(&v.template get<2>());
	o.via.array.ptr[3].convert<A3>(&v.template get<3>());
	o.via.array.ptr[4].convert<A4>(&v.template get<4>());
	o.via.array.ptr[5].convert<A5>(&v.template get<5>());
	o.via.array.ptr[6].convert<A6>(&v.template get<6>());
	o.via.array.ptr[7].convert<A7>(&v.template get<7>());
	o.via.array.ptr[8].convert<A8>(&v.template get<8>());
	o.via.array.ptr[9].convert<A9>(&v.template get<9>());
	o.via.array.ptr[10].convert<A10>(&v.template get<10>());
	o.via.array.ptr[11].convert<A11>(&v.template get<11>());
	o.via.array.ptr[12].convert<A12>(&v.template get<12>());
	o.via.array.ptr[13].convert<A13>(&v.template get<13>());
	o.via.array.ptr[14].convert<A14>(&v.template get<14>());
	o.via.array.ptr[15].convert<A15>(&v.template get<15>());
	return v;
}



template <typename Stream>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<>& v) {
	o.pack_array(0);
	return o;
}

template <typename Stream, typename A0>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0>& v) {
	o.pack_array(1);
	
	o.pack(v.template get<0>());
	return o;
}

template <typename Stream, typename A0, typename A1>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1>& v) {
	o.pack_array(2);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2>& v) {
	o.pack_array(3);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3>& v) {
	o.pack_array(4);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4>& v) {
	o.pack_array(5);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5>& v) {
	o.pack_array(6);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6>& v) {
	o.pack_array(7);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7>& v) {
	o.pack_array(8);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8>& v) {
	o.pack_array(9);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9>& v) {
	o.pack_array(10);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10>& v) {
	o.pack_array(11);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11>& v) {
	o.pack_array(12);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12>& v) {
	o.pack_array(13);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13>& v) {
	o.pack_array(14);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14>& v) {
	o.pack_array(15);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	return o;
}

template <typename Stream, typename A0, typename A1, typename A2, typename A3, typename A4, typename A5, typename A6, typename A7, typename A8, typename A9, typename A10, typename A11, typename A12, typename A13, typename A14, typename A15>
const packer<Stream>& operator<< (
		packer<Stream>& o,
		const type::tuple<A0, A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15>& v) {
	o.pack_array(16);
	
	o.pack(v.template get<0>());
	o.pack(v.template get<1>());
	o.pack(v.template get<2>());
	o.pack(v.template get<3>());
	o.pack(v.template get<4>());
	o.pack(v.template get<5>());
	o.pack(v.template get<6>());
	o.pack(v.template get<7>());
	o.pack(v.template get<8>());
	o.pack(v.template get<9>());
	o.pack(v.template get<10>());
	o.pack(v.template get<11>());
	o.pack(v.template get<12>());
	o.pack(v.template get<13>());
	o.pack(v.template get<14>());
	o.pack(v.template get<15>());
	return o;
}



}  // namespace msgpack

#endif /* msgpack/type/tuple.hpp */

