require 'msgpack'

@up = MessagePack::Unpacker.new

def check(bytes, should)
	puts "----"
	@up.reset
	src = bytes.pack('C*')
	ret = @up.execute(src, 0)
	if ret != src.length
		puts "** EXTRA BYTES **"
	end
	puts bytes.map{|x|"%x"%x}.join(' ')
	data = @up.data
	p data
	if data != should
		puts "** TEST FAILED **"
		p should
	end
end

# SimpleValue
check([
	0x93, 0xc0, 0xc2, 0xc3,
], [nil,false,true])

# Fixnum
check([
	0x92,
		0x93, 0x00, 0x40, 0x7f,
		0x93, 0xe0, 0xf0, 0xff,
], [[0,64,127], [-32,-16,-1]])

# FixArray
check([
	0x92,
		0x90,
		0x91,
			0x91, 0xc0,
], [[],[[nil]]])


# FixRaw
check([
	0x94,
		0xa0,
		0xa1, ?a,
		0xa2, ?b, ?c,
		0xa3, ?d, ?e, ?f,
], ["","a","bc","def"])

# FixMap
check([
	0x82,
		0xc2, 0x81,
			0xc0, 0xc0,
		0xc3, 0x81,
			0xc0, 0x80,
], {false=>{nil=>nil}, true=>{nil=>{}}})

# unsigned int
check([
	0x99,
		0xcc, 0,
		0xcc, 128,
		0xcc, 255,
		0xcd, 0x00, 0x00,
		0xcd, 0x80, 0x00,
		0xcd, 0xff, 0xff,
		0xce, 0x00, 0x00, 0x00, 0x00,
		0xce, 0x80, 0x00, 0x00, 0x00,
		0xce, 0xff, 0xff, 0xff, 0xff,
], [0, 128, 255, 0, 32768, 65535, 0, 2147483648, 4294967295])

# signed int
check([
	0x99,
		0xd0, 0,
		0xd0, 128,
		0xd0, 255,
		0xd1, 0x00, 0x00,
		0xd1, 0x80, 0x00,
		0xd1, 0xff, 0xff,
		0xd2, 0x00, 0x00, 0x00, 0x00,
		0xd2, 0x80, 0x00, 0x00, 0x00,
		0xd2, 0xff, 0xff, 0xff, 0xff,
], [0, -128, -1, 0, -32768, -1, 0, -2147483648, -1])

# raw
check([
	0x96,
		0xda, 0x00, 0x00,
		0xda, 0x00, 0x01, ?a,
		0xda, 0x00, 0x02, ?a, ?b,
		0xdb, 0x00, 0x00, 0x00, 0x00,
		0xdb, 0x00, 0x00, 0x00, 0x01, ?a,
		0xdb, 0x00, 0x00, 0x00, 0x02, ?a, ?b,
], ["", "a", "ab", "", "a", "ab"])

# array
check([
	0x96,
		0xdc, 0x00, 0x00,
		0xdc, 0x00, 0x01, 0xc0,
		0xdc, 0x00, 0x02, 0xc2, 0xc3,
		0xdd, 0x00, 0x00, 0x00, 0x00,
		0xdd, 0x00, 0x00, 0x00, 0x01, 0xc0,
		0xdd, 0x00, 0x00, 0x00, 0x02, 0xc2, 0xc3
], [[], [nil], [false,true], [], [nil], [false,true]])

# map
check([
	0x96,
		0xde, 0x00, 0x00,
		0xde, 0x00, 0x01, 0xc0, 0xc2,
		0xde, 0x00, 0x02, 0xc0, 0xc2, 0xc3, 0xc2,
		0xdf, 0x00, 0x00, 0x00, 0x00,
		0xdf, 0x00, 0x00, 0x00, 0x01, 0xc0, 0xc2,
		0xdf, 0x00, 0x00, 0x00, 0x02, 0xc0, 0xc2, 0xc3, 0xc2,
], [{}, {nil=>false}, {true=>false, nil=>false}, {}, {nil=>false}, {true=>false, nil=>false}])


