/**********************************************************
Copyright(C) 2006-2012 Eisai Co., Ltd. All rights reserved.
-----------------------------------------------------------
   @addtogroup C++ CommonFunctions
	@file       Algo_inline.h
	@brief      Lib֐ŒxߎASYō
	@date       2012.12.05
	@author     M.Fukuda
	@version    1.0.0
    @note       BoostAOCuɊւ鏈͓ȂB
**********************************************************/


//	std::sqrťvZx̂
//	j[g@gߎASYŌvZ
//
//	匳̕
//	http://www.riken.jp/brict/Ijiri/study/fastsqrt.html
//
//	Xɂ̘̌_
//		[1] David Eberly, Fast Inverse Square Root (Revisited), 
//			http://www.geometrictools.com/Documentation/ FastInverseSqrt.pdf, 1/2002-.
//
//  Ce[VQŁ@
//    std::sqrtƏ_6ʂ܂  {ȏ㑬xoB
//  Ce[V3
//    std::sqrtƏ_8-9ʂ܂  std::sqrt葬
//  덷ełđxKvȂ獟𐄏

// Ă@sqrt
inline double t_sqrtD(const double &x) {
	double xHalf = 0.5 * x;
	long long int tmp = 0x5FE6EB50C7B537AAl - ( *(long long int*)&x >> 1);
	double xRes = * (double*)&tmp;

	//Ce[V
	xRes *= (1.5 - (xHalf * xRes * xRes));
	xRes *= (1.5 - (xHalf * xRes * xRes));
	return xRes * x;
}
