/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.descriptor;

import org.mtzky.reflect.PropDesc;

/**
 * @see LucenePropertyConfig
 * @author mtzky
 */
public class BeanPropertyConfig extends SimplePropertyConfig {

	private final PropDesc propDesc;

	/**
	 * @param name
	 * @param propDesc
	 */
	public BeanPropertyConfig(final String name, final PropDesc propDesc) {
		super(name);
		if (propDesc == null) {
			throw new NullPointerException("propDesc");
		}
		this.propDesc = propDesc;
	}

	public PropDesc getPropDesc() {
		return propDesc;
	}

}
