/*
 * Copyright (C) 2010-2011 Mtzky.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *         http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.lucene.descriptor;

import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.mtzky.reflect.PropDesc;

/**
 * @param <E>
 *            entity
 * @see BeanLuceneField
 * @author mtzky
 */
public class BeanPropertyDesc<E> extends AbstractPropertyDesc<E> {

	private final PropDesc desc;

	public BeanPropertyDesc(final BeanPropertyConfig config) {
		super(config);
		this.desc = config.getPropDesc();
	}

	@Override
	public Fieldable getField(final E bean) {
		return getFieldByValue(desc.get(bean));
	}

	@Override
	public void setField(final E bean, final Fieldable fieldable) {
		desc.set(bean, getValue(fieldable));
	}

	@Override
	public Term getTerm(final E bean) {
		return getTermByValue(desc.get(bean));
	}

}
