/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.mtzky.lucene.LuceneIndexSearcherRequest;

public abstract class AbstractIndexSearcherRequest
implements LuceneIndexSearcherRequest {
    private BooleanQuery query = null;
    private int limit = 10;
    private int offset = 0;
    private Filter filter = null;
    private final List<SortField> sortFields = new ArrayList<SortField>();

    @Override
    public Query getQuery() {
        if (this.query == null) {
            return DEFAULT_QUERY;
        }
        return this.query;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Sort getSort() {
        int len = this.sortFields.size();
        if (0 < len) {
            return new Sort(this.sortFields.toArray(new SortField[len]));
        }
        return null;
    }

    protected void addQuery(Query query) {
        this.addQuery(query, BooleanClause.Occur.MUST);
    }

    protected void addQuery(Query query, BooleanClause.Occur occur) {
        if (this.query == null) {
            this.query = new BooleanQuery();
        }
        this.query.add(query, occur);
    }

    protected void setFilter(Filter filter) {
        this.filter = filter;
    }

    protected void setLimit(int limit) {
        this.limit = limit;
    }

    protected void setOffset(int offset) {
        this.offset = offset;
    }

    protected void addSort(String ... fields) {
        for (String field : fields) {
            this.sortFields.add(new SortField(field, 3));
        }
    }

    protected void addSort(String field, boolean reverse) {
        this.sortFields.add(new SortField(field, 3, reverse));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("query=[").append(this.getQuery()).append("]");
        if (this.filter != null) {
            sb.append(", filter=[").append(this.filter).append("]");
        }
        sb.append(", limit=").append(this.limit);
        sb.append(", offset=").append(this.offset);
        if (!this.sortFields.isEmpty()) {
            sb.append(", sort=").append(this.sortFields);
        }
        return sb.toString();
    }
}

