/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.mtzky.io.Closable;
import org.mtzky.io.ClosingGuardian;
import org.mtzky.io.IOUtils;
import org.mtzky.log.GenericMarker;
import org.mtzky.lucene.LuceneIndexSearcher;
import org.mtzky.lucene.LuceneIndexWriter;
import org.mtzky.lucene.descriptor.LuceneDocumentDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LuceneIndex<E>
implements Closable {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneIndex.class);
    private final Object guardian = new ClosingGuardian((Closable)this);
    private boolean closed = false;
    private final Lock dirLock = new ReentrantLock();
    private Directory directory;
    private LuceneDocumentDesc<E> desc;
    private LuceneIndexSearcher<E> searcher = null;
    private long version;

    public LuceneIndex(LuceneDocumentDesc<E> desc) throws CorruptIndexException, IOException {
        this(desc, LuceneIndex.newEmptyDirectory(desc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Directory newEmptyDirectory(LuceneDocumentDesc<?> desc) {
        RAMDirectory dir = new RAMDirectory();
        IndexWriter w = null;
        try {
            w = new IndexWriter((Directory)dir, new IndexWriterConfig(Version.LUCENE_31, desc.getAnalyzer()));
            w.optimize();
        }
        catch (Exception e) {
            try {
                String msg = "FAILED to initialize directory: " + dir;
                LOG.warn((Marker)GenericMarker.FAILED_TO_INITIALIZE, msg, (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(w);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)w);
        }
        IOUtils.closeQuietly((Closeable)w);
        return dir;
    }

    public LuceneIndex(LuceneDocumentDesc<E> desc, Directory dir) throws CorruptIndexException, IOException {
        this.desc = desc;
        this.directory = dir;
        this.version = IndexReader.getCurrentVersion((Directory)dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Directory getDirectory() {
        try {
            this.dirLock.lock();
            Directory directory = this.directory;
            return directory;
        }
        finally {
            this.dirLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectory(Directory directory) throws CorruptIndexException, IOException {
        try {
            this.dirLock.lock();
            long version = IndexReader.getCurrentVersion((Directory)directory);
            if (version == this.version) {
                if (LOG.isDebugEnabled((Marker)GenericMarker.CANCEL)) {
                    String fmt = "NOT switch a directory due to the same version {}";
                    LOG.debug((Marker)GenericMarker.CANCEL, "NOT switch a directory due to the same version {}", (Object)version);
                }
                return;
            }
            IOUtils.closeQuietly(this.searcher);
            this.searcher = null;
            IOUtils.closeQuietly((Closeable)this.directory);
            this.directory = directory;
            this.version = version;
        }
        finally {
            this.dirLock.unlock();
        }
    }

    public LuceneIndexWriter<E> getWriter() throws CorruptIndexException, LockObtainFailedException, IOException {
        return new LuceneIndexWriter<E>(this.getDirectory(), this.desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withWriter(WriterCallback<E> callback) throws CorruptIndexException, LockObtainFailedException, IOException {
        LuceneIndexWriter<E> writer = null;
        try {
            this.dirLock.lock();
            writer = this.getWriter();
            callback.call(writer);
        }
        finally {
            IOUtils.closeQuietly(writer);
            this.dirLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneIndexSearcher<E> getSearcher() throws CorruptIndexException, IOException {
        try {
            this.dirLock.lock();
            long version = IndexReader.getCurrentVersion((Directory)this.directory);
            if (this.searcher == null || this.searcher.isClosed()) {
                this.version = version;
                this.searcher = this.createSearcher();
            } else if (version != this.version) {
                this.searcher.closeWhenDone();
                this.version = version;
                this.searcher = this.createSearcher();
            }
            this.searcher.open();
            LuceneIndexSearcher<E> luceneIndexSearcher = this.searcher;
            return luceneIndexSearcher;
        }
        finally {
            this.dirLock.unlock();
        }
    }

    protected LuceneIndexSearcher<E> createSearcher() throws CorruptIndexException, IOException {
        return new LuceneIndexSearcher<E>(this.getDirectory(), this.desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        try {
            this.dirLock.lock();
            boolean bl = this.closed;
            return bl;
        }
        finally {
            this.dirLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.dirLock.lock();
            if (this.searcher != null && !this.searcher.isClosed()) {
                this.searcher.closeWhenDone();
            }
            this.searcher = null;
            IOUtils.closeQuietly((Closeable)this.directory);
            this.closed = true;
        }
        finally {
            this.dirLock.unlock();
        }
    }

    public static interface WriterCallback<E> {
        public void call(LuceneIndexWriter<E> var1) throws CorruptIndexException, IOException;
    }
}

