/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LuceneIndexSearcherResponse<E>
implements List<E>,
Serializable {
    private static final long serialVersionUID = -1925791784907186977L;
    private List<E> entities;
    private int limit = 10;
    private int offset = 0;
    private int totalHits = 0;

    public LuceneIndexSearcherResponse() {
        this(10);
    }

    public LuceneIndexSearcherResponse(int initialCapacity) {
        this.entities = new ArrayList(initialCapacity);
    }

    public int getCurrentPageIndex() {
        int i = this.offset / this.limit;
        if (this.offset % this.limit == 0) {
            return i;
        }
        return i + 1;
    }

    public int getCurrentPageNumber() {
        return this.getCurrentPageIndex() + 1;
    }

    public boolean hasPrevPage() {
        return 0 < this.offset;
    }

    public boolean hasNextPage() {
        return this.offset + this.limit < this.totalHits;
    }

    public boolean getHasPrevPage() {
        return this.hasPrevPage();
    }

    public boolean getHasNextPage() {
        return this.hasNextPage();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.limit;
        result = 31 * result + this.offset;
        result = 31 * result + this.totalHits;
        result = 31 * result + (this.entities == null ? 0 : ((Object)this.entities).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LuceneIndexSearcherResponse other = (LuceneIndexSearcherResponse)obj;
        if (this.limit != other.limit) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.totalHits != other.totalHits) {
            return false;
        }
        return !(this.entities == null ? other.entities != null : !((Object)this.entities).equals(other.entities));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("totalHits: ").append(this.totalHits);
        sb.append(", limit: ").append(this.limit);
        sb.append(", offset: ").append(this.offset);
        sb.append(", size: ").append(this.size());
        if (!this.entities.isEmpty()) {
            sb.append(", first=[").append(this.entities.get(0)).append("]");
        }
        return sb.toString();
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public void setTotalHits(int totalHits) {
        this.totalHits = totalHits;
    }

    @Override
    public boolean add(E e) {
        return this.entities.add(e);
    }

    @Override
    public void add(int index, E element) {
        this.entities.add(index, element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.entities.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.entities.addAll(index, c);
    }

    @Override
    public void clear() {
        this.entities.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.entities.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.entities.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this.entities.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.entities.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this.entities.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.entities.iterator();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.entities.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.entities.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.entities.listIterator(index);
    }

    @Override
    public boolean remove(Object o) {
        return this.entities.remove(o);
    }

    @Override
    public E remove(int index) {
        return this.entities.remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.entities.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.entities.removeAll(c);
    }

    @Override
    public E set(int index, E element) {
        return this.entities.set(index, element);
    }

    @Override
    public int size() {
        return this.entities.size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.entities.subList(fromIndex, toIndex);
    }

    @Override
    public Object[] toArray() {
        return this.entities.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.entities.toArray(a);
    }
}

