/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.Version;
import org.mtzky.io.Closable;
import org.mtzky.io.ClosingGuardian;
import org.mtzky.log.GenericMarker;
import org.mtzky.lucene.descriptor.LuceneDocumentDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class LuceneIndexWriter<E>
extends IndexWriter
implements Closable {
    private static final Logger LOG = LoggerFactory.getLogger(LuceneIndexWriter.class);
    private final Object guardian = new ClosingGuardian((Closable)this);
    private boolean closed = false;
    private final LuceneDocumentDesc<E> desc;

    public LuceneIndexWriter(Directory d, LuceneDocumentDesc<E> desc) throws CorruptIndexException, LockObtainFailedException, IOException {
        super(d, new IndexWriterConfig(Version.LUCENE_31, desc.getAnalyzer()));
        this.desc = desc;
    }

    public void addDocument(E entity) throws CorruptIndexException, IOException {
        Document doc = this.desc.createDocument(entity);
        this.addDocument(doc);
        if (LOG.isDebugEnabled((Marker)GenericMarker.ADD)) {
            LOG.debug((Marker)GenericMarker.ADD, "add a document [{}]", (Object)doc);
        }
    }

    public void updateDocument(E entity) throws CorruptIndexException, IOException {
        Document doc = this.desc.createDocument(entity);
        this.updateDocument(this.desc.getIdTermByEntity(entity), doc);
        if (LOG.isDebugEnabled((Marker)GenericMarker.CHANGE)) {
            LOG.debug((Marker)GenericMarker.CHANGE, "update a document [{}]", (Object)doc);
        }
    }

    public void deleteDocument(E entity) throws CorruptIndexException, IOException {
        Term term = this.desc.getIdTermByEntity(entity);
        this.deleteDocuments(term);
        if (LOG.isDebugEnabled((Marker)GenericMarker.DELETE)) {
            LOG.debug((Marker)GenericMarker.DELETE, "delete a document by term [{}]", (Object)term);
        }
    }

    public void deleteDocumentById(Object value) throws CorruptIndexException, IOException {
        this.deleteDocuments(this.desc.getIdTermByValue(value));
        if (LOG.isDebugEnabled((Marker)GenericMarker.DELETE)) {
            LOG.debug((Marker)GenericMarker.DELETE, "delete a document by ID [{}]", value);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }
}

