/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.descriptor;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.LimitTokenCountAnalyzer;
import org.apache.lucene.analysis.PerFieldAnalyzerWrapper;
import org.apache.lucene.index.Term;
import org.mtzky.lucene.analyzer.AnalyzerWrapper;
import org.mtzky.lucene.descriptor.LuceneDocumentDesc;
import org.mtzky.lucene.descriptor.LucenePropertyDesc;
import org.mtzky.reflect.IterableUtils;

public abstract class AbstractLuceneDocumentDesc<E>
implements LuceneDocumentDesc<E> {
    private final PerFieldAnalyzerWrapper analyzer = new PerFieldAnalyzerWrapper((Analyzer)new KeywordAnalyzer());
    private final LucenePropertyDesc<E> idPropDesc;

    public AbstractLuceneDocumentDesc(LucenePropertyDesc<E>[] descs) {
        this.idPropDesc = (LucenePropertyDesc)IterableUtils.each((Object[])descs, (IterableUtils.Find)new IterableUtils.Find<LucenePropertyDesc<E>>(){

            public boolean call(LucenePropertyDesc<E> desc) {
                return desc.isId();
            }
        });
        if (this.idPropDesc == null) {
            throw new IllegalArgumentException("Requires the ID field");
        }
        for (LucenePropertyDesc<E> desc : descs) {
            AnalyzerWrapper a = new AnalyzerWrapper(desc);
            int maxTokenCount = desc.getMaxTokenCount();
            if (0 < maxTokenCount) {
                a = new LimitTokenCountAnalyzer((Analyzer)a, maxTokenCount);
            }
            this.analyzer.addAnalyzer(desc.getName(), (Analyzer)a);
        }
    }

    @Override
    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    @Override
    public String getIdName() {
        return this.idPropDesc.getName();
    }

    @Override
    public Term getIdTermByEntity(E entity) {
        return this.idPropDesc.getTerm(entity);
    }

    @Override
    public Term getIdTermByValue(Object value) {
        return this.idPropDesc.getTermByValue(value);
    }
}

