/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.descriptor;

import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.document.Field;
import org.mtzky.lucene.type.LuceneFieldStrategy;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface BeanLuceneField {
    public boolean id() default false;

    public String name() default "";

    public Field.Store store() default Field.Store.YES;

    public Field.Index index() default Field.Index.ANALYZED;

    public Field.TermVector termVector() default Field.TermVector.NO;

    public int maxTokenCount() default 0;

    public String format() default "";

    public Class<? extends LuceneFieldStrategy> luceneFieldStrategy() default LuceneFieldStrategy.class;

    public Class<? extends Analyzer> analyzer() default KeywordAnalyzer.class;

    public Class<? extends Reader>[] normalizers() default {};

    public Class<? extends TokenFilter>[] filters() default {};
}

