/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.descriptor;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.AbstractLuceneDocumentDesc;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.descriptor.LucenePropertyDesc;
import org.mtzky.lucene.descriptor.MapPropertyDesc;

public class MapDocumentDesc<T>
extends AbstractLuceneDocumentDesc<Map<String, T>> {
    private final LucenePropertyDesc<Map<String, T>>[] descs;

    public MapDocumentDesc(LucenePropertyConfig ... configs) {
        this(MapDocumentDesc.config(configs));
    }

    private static <T> LucenePropertyDesc[] config(LucenePropertyConfig[] configs) {
        if (configs == null) {
            throw new NullPointerException("configs");
        }
        int len = configs.length;
        LucenePropertyDesc[] descs = new LucenePropertyDesc[len];
        for (int i = 0; i < len; ++i) {
            LucenePropertyConfig config = configs[i];
            if (config == null) {
                throw new NullPointerException("configs[" + i + "]");
            }
            descs[i] = new MapPropertyDesc(config);
        }
        return descs;
    }

    private MapDocumentDesc(LucenePropertyDesc<Map<String, T>>[] descs) {
        super(descs);
        this.descs = descs;
    }

    @Override
    public Document createDocument(Map<String, T> map) {
        Document doc = new Document();
        for (LucenePropertyDesc<Map<String, T>> desc : this.descs) {
            doc.add(desc.getField(map));
        }
        return doc;
    }

    @Override
    public Map<String, T> createEntity(Document document) {
        HashMap map = new HashMap();
        for (LucenePropertyDesc<Map<String, T>> desc : this.descs) {
            Fieldable fieldable = document.getFieldable(desc.getName());
            if (fieldable == null) continue;
            desc.setField(map, fieldable);
        }
        return map;
    }
}

