/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.type.LuceneDateStrategy;
import org.mtzky.lucene.type.LuceneFieldStrategyType;

@LuceneFieldStrategyType(value=Calendar.class)
public class LuceneCalendarStrategy
extends LuceneDateStrategy {
    private final boolean original;
    private final String format;

    public LuceneCalendarStrategy(LucenePropertyConfig config) {
        super(config);
        this.format = config.getFormat();
        this.original = this.format.isEmpty();
    }

    @Override
    public <T> T getValue(Fieldable field) {
        Calendar cal = Calendar.getInstance();
        String v = field.stringValue();
        if (this.original) {
            cal.setTimeInMillis(Long.parseLong(v));
            return (T)cal;
        }
        SimpleDateFormat format = new SimpleDateFormat(this.format);
        Date date = ((DateFormat)format).parse(v, new ParsePosition(0));
        cal.setTimeInMillis(date != null ? date.getTime() : 0L);
        return (T)cal;
    }

    @Override
    protected long toLong(Object value) {
        return value != null ? ((Calendar)value).getTimeInMillis() : 0L;
    }

    @Override
    protected String toString(Object val) {
        Calendar cal = val instanceof Calendar ? (Calendar)val : null;
        SimpleDateFormat format = new SimpleDateFormat(this.format);
        format.setTimeZone(cal.getTimeZone());
        return format.format(cal != null ? cal.getTime() : new Date(0L));
    }
}

