/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.type.LuceneFieldStrategyType;
import org.mtzky.lucene.type.LuceneStringStrategy;

@LuceneFieldStrategyType(value=Character.class)
public class LuceneCharacterStrategy
extends LuceneStringStrategy {
    private static final Character EMPTY = Character.valueOf(' ');
    private final boolean original;
    private final String format;

    public LuceneCharacterStrategy(LucenePropertyConfig config) {
        super(config);
        this.format = config.getFormat();
        this.original = this.format.isEmpty();
    }

    @Override
    public Fieldable getField(Object value) {
        Fieldable f = super.getField(value);
        f.setOmitNorms(true);
        return f;
    }

    @Override
    public <T> T getValue(Fieldable field) {
        String v = field.stringValue();
        return (T)(v.isEmpty() ? EMPTY : Character.valueOf(v.charAt(0)));
    }

    @Override
    protected String toString(Object value) {
        Character v;
        Character c = v = value != null ? (Character)value : EMPTY;
        if (this.original) {
            return v.toString();
        }
        return String.format(this.format, v);
    }
}

