/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.mtzky.lucene.type.LuceneFieldStrategy;
import org.mtzky.lucene.type.LuceneFieldStrategyType;
import org.mtzky.reflect.IterableUtils;
import org.mtzky.reflect.PackageDesc;

public class LuceneFieldStrategyFactory {
    public static final String DEFAULT_LUCENE_FIELD_STRATEGY_PACKAGE_NAME = LuceneFieldStrategy.class.getPackage().getName();
    private static final IterableUtils.Find<Class<?>> FILTER = new IterableUtils.Find<Class<?>>(){

        public boolean call(Class<?> value) {
            return LuceneFieldStrategy.class.isAssignableFrom(value) && value.getAnnotation(LuceneFieldStrategyType.class) != null;
        }
    };
    private final Map<Class<?>, Class<? extends LuceneFieldStrategy>> types;
    private final Lock lock = new ReentrantLock();

    public LuceneFieldStrategyFactory() {
        this.types = new HashMap();
        this.addPackageName(DEFAULT_LUCENE_FIELD_STRATEGY_PACKAGE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackageName(String packageName) {
        PackageDesc desc;
        try {
            desc = new PackageDesc(packageName, FILTER);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        try {
            this.lock.lock();
            for (Class c : desc.getClasses()) {
                this.types.put(c.getAnnotation(LuceneFieldStrategyType.class).value(), c);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<? extends LuceneFieldStrategy> getLuceneFieldStrategy(Class<?> type) {
        try {
            this.lock.lock();
            Class<? extends LuceneFieldStrategy> c = this.types.get(type);
            if (c != null) {
                Class<? extends LuceneFieldStrategy> clazz = c;
                return clazz;
            }
            if (type.isAssignableFrom(String.class)) {
                Class<? extends LuceneFieldStrategy> clazz = this.types.get(String.class);
                return clazz;
            }
            if (type.isAssignableFrom(BigDecimal.class)) {
                Class<? extends LuceneFieldStrategy> clazz = this.types.get(BigDecimal.class);
                return clazz;
            }
            for (Class<?> cls : this.types.keySet()) {
                if (!type.isAssignableFrom(cls)) continue;
                Class<? extends LuceneFieldStrategy> clazz = this.types.get(cls);
                return clazz;
            }
        }
        finally {
            this.lock.unlock();
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }
}

