/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.type.LuceneFieldStrategyType;
import org.mtzky.lucene.type.LuceneIntegerStrategy;

@LuceneFieldStrategyType(value=Short.class)
public class LuceneShortStrategy
extends LuceneIntegerStrategy {
    private final boolean original;
    private final String format;

    public LuceneShortStrategy(LucenePropertyConfig config) {
        super(config);
        this.format = config.getFormat();
        this.original = this.format.isEmpty();
    }

    @Override
    public <T> T getValue(Fieldable field) {
        String v = field.stringValue();
        if (this.original) {
            return (T)Short.valueOf(v);
        }
        DecimalFormat format = new DecimalFormat(this.format);
        format.setParseBigDecimal(true);
        BigDecimal d = (BigDecimal)format.parse(v, new ParsePosition(0));
        return (T)Short.valueOf(d != null ? d.shortValue() : (short)0);
    }

    @Override
    protected int toInt(Object value) {
        return value != null ? (int)((Short)value).shortValue() : 0;
    }
}

