/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.lucene.document.Fieldable;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.type.LuceneDateStrategy;
import org.mtzky.lucene.type.LuceneFieldStrategyType;

@LuceneFieldStrategyType(value=java.sql.Date.class)
public class LuceneSqlDateStrategy
extends LuceneDateStrategy {
    private final boolean original;
    private final String format;

    public LuceneSqlDateStrategy(LucenePropertyConfig config) {
        super(config);
        this.format = config.getFormat();
        this.original = this.format.isEmpty();
    }

    @Override
    public <T> T getValue(Fieldable field) {
        String v = field.stringValue();
        if (this.original) {
            return (T)new java.sql.Date(Long.parseLong(v));
        }
        SimpleDateFormat format = new SimpleDateFormat(this.format);
        Date date = ((DateFormat)format).parse(v, new ParsePosition(0));
        return (T)new java.sql.Date(date.getTime());
    }
}

