/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.lucene.type;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.mtzky.lucene.descriptor.LucenePropertyConfig;
import org.mtzky.lucene.type.LuceneFieldStrategy;
import org.mtzky.lucene.type.LuceneFieldStrategyType;

@LuceneFieldStrategyType(value=String.class)
public class LuceneStringStrategy
implements LuceneFieldStrategy {
    private static final String EMPTY = "";
    private final String name;
    private final Field.Store store;
    private final Field.Index index;

    public LuceneStringStrategy(LucenePropertyConfig config) {
        this.name = config.getName();
        this.store = config.getStore();
        this.index = config.getIndex();
    }

    @Override
    public Fieldable getField(Object value) {
        return new Field(this.name, this.toString(value), this.store, this.index);
    }

    @Override
    public <T> T getValue(Fieldable field) {
        return (T)field.stringValue();
    }

    @Override
    public Term getTerm(Object value) {
        return new Term(this.name, this.toString(value));
    }

    protected String toString(Object value) {
        return value != null ? value.toString() : EMPTY;
    }
}

