/*
 * Copyright (C) 2010-2011 Mtzky.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.mtzky.date;

/**
 * <p>
 * Measures an elapsed time in milliseconds.
 * </p>
 * 
 * @author mtzky
 */
public class StopWatch {

	private final long start = System.currentTimeMillis();

	private long elapsed = -1L;

	/**
	 * <p>
	 * Returns elapsed time, but not stops measuring.
	 * </p>
	 * 
	 * @return elapsed time in milliseconds
	 */
	public synchronized long glance() {
		return isRunning() ? (System.currentTimeMillis() - start) : elapsed;
	}

	/**
	 * <p>
	 * Stops to measure an elapsed time.
	 * </p>
	 * 
	 * @return elapsed time in milliseconds
	 * @throws IllegalStateException
	 *             if already stopped
	 */
	public synchronized long stop() {
		if (!isRunning()) {
			throw new IllegalStateException("StopWatch was already stopped");
		}
		return (elapsed = System.currentTimeMillis() - start);
	}

	/**
	 * @return {@code true} if running
	 */
	public synchronized boolean isRunning() {
		return elapsed < 0;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder();
		sb.append("elapsed: ").append(glance()).append("ms");
		return sb.toString();
	}

}
