/*
 * Decompiled with CFR 0.152.
 */
package org.mtzky.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PushbackReader;
import java.io.Reader;
import org.mtzky.io.Closable;
import org.mtzky.io.SPrintStream;
import org.mtzky.lang.ThreadUtils;
import org.mtzky.lang.UtilConstractedAssertionError;
import org.mtzky.log.GenericMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

public class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);

    private IOUtils() {
        throw new UtilConstractedAssertionError(IOUtils.class);
    }

    public static void closeQuietly(Closable closable) {
        if (closable == null) {
            return;
        }
        if (closable.isClosed()) {
            return;
        }
        try {
            closable.close();
        }
        catch (IOException e) {
            Object[] args = new Object[]{closable, ThreadUtils.getCallingStackTraceElement()};
            LOG.warn((Marker)GenericMarker.FAILED_TO_CLOSE, "FAILED to close {} at {}", args);
        }
    }

    public static void closeQuietly(Closeable closaable) {
        if (closaable == null) {
            return;
        }
        try {
            closaable.close();
        }
        catch (IOException e) {
            Object[] args = new Object[]{closaable, ThreadUtils.getCallingStackTraceElement()};
            LOG.warn((Marker)GenericMarker.FAILED_TO_CLOSE, "FAILED to close {} at {}", args);
        }
    }

    public static String trapSysOut(Runnable runnable) throws Throwable {
        PrintStream originalOut = System.out;
        SPrintStream out = new SPrintStream();
        try {
            System.setOut(out);
            runnable.run();
        }
        catch (Throwable e) {
            out.flush();
            originalOut.println(out);
            throw e;
        }
        finally {
            out.flush();
            System.setOut(originalOut);
        }
        return ((Object)out).toString();
    }

    public static PushbackReader toPushbackReader(Reader reader) {
        if (reader instanceof PushbackReader) {
            return (PushbackReader)reader;
        }
        return new PushbackReader(reader);
    }
}

