/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.Accordion;
import controlP5.Bang;
import controlP5.Button;
import controlP5.CColor;
import controlP5.Chart;
import controlP5.CheckBox;
import controlP5.ColorPicker;
import controlP5.ControlGroup;
import controlP5.ControlKey;
import controlP5.ControlP5;
import controlP5.ControlP5Constants;
import controlP5.ControlWindow;
import controlP5.Controller;
import controlP5.ControllerAutomator;
import controlP5.ControllerGroup;
import controlP5.ControllerInterface;
import controlP5.ControllerLayout;
import controlP5.ControllerProperties;
import controlP5.DropdownList;
import controlP5.FieldChangedListener;
import controlP5.Group;
import controlP5.Knob;
import controlP5.ListBox;
import controlP5.Matrix;
import controlP5.MultiList;
import controlP5.Numberbox;
import controlP5.PAppletWindow;
import controlP5.RadioButton;
import controlP5.Range;
import controlP5.Slider;
import controlP5.Slider2D;
import controlP5.Tab;
import controlP5.Textarea;
import controlP5.Textfield;
import controlP5.Textlabel;
import controlP5.Toggle;
import controlP5.Tooltip;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import processing.core.PApplet;
import processing.core.PVector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlP5Base
implements ControlP5Constants {
    private ControlP5 cp5;
    ControllerProperties _myProperties;
    private ControllerAutomator _myAutomator;
    protected Map<Object, ArrayList<ControllerInterface<?>>> _myObjectToControllerMap = new HashMap();
    protected Map<String, FieldChangedListener> _myFieldChangedListenerMap = new HashMap<String, FieldChangedListener>();
    protected ControllerGroup<?> currentGroupPointer;
    protected boolean isCurrentGroupPointerClosed = true;
    protected int autoDirection = 0;

    public Tab getDefaultTab() {
        return (Tab)this.cp5.controlWindow.getTabs().get(1);
    }

    protected void init(ControlP5 controlP5) {
        this.cp5 = controlP5;
        this._myProperties = new ControllerProperties(this.cp5);
        this._myAutomator = new ControllerAutomator(this.cp5);
        this.currentGroupPointer = this.cp5.controlWindow.getTab("default");
    }

    public ControllerLayout getLayout() {
        return new ControllerLayout(this.cp5);
    }

    public Tab addTab(String string) {
        return this.addTab(this.cp5.controlWindow, string);
    }

    public Tab addTab(PApplet pApplet, String string) {
        return this.addTab(this.cp5.controlWindow, string);
    }

    public Tab addTab(ControlWindow controlWindow, String string) {
        for (int i = 0; i < controlWindow.getTabs().size(); ++i) {
            if (!controlWindow.getTabs().get(i).getName().equals(string)) continue;
            return (Tab)controlWindow.getTabs().get(i);
        }
        Tab tab = new Tab(this.cp5, controlWindow, string);
        controlWindow.getTabs().add(tab);
        return tab;
    }

    public Button addButton(Object object, String string, String string2, float f, int n, int n2, int n3, int n4) {
        Button button = new Button(this.cp5, (ControllerGroup)this.cp5.controlWindow.getTabs().get(1), string2, f, n, n2, n3, n4);
        this.cp5.register(object, string, button);
        button.registerProperty("value");
        button.getProperty("value").disable();
        return button;
    }

    public Button addButton(String string, float f, int n, int n2, int n3, int n4) {
        return this.addButton(null, "", string, f, n, n2, n3, n4);
    }

    public Bang addBang(Object object, String string, String string2, int n, int n2, int n3, int n4) {
        Bang bang = new Bang(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string2, n, n2, n3, n4);
        this.cp5.register(object, string, bang);
        bang.registerProperty("value");
        bang.getProperty("value").disable();
        return bang;
    }

    public Bang addBang(String string, int n, int n2) {
        return this.addBang(null, "", string, n, n2, 20, 20);
    }

    public Bang addBang(String string) {
        return this.addBang(null, "", string);
    }

    public Bang addBang(String string, int n, int n2, int n3, int n4) {
        return this.addBang(null, "", string, n, n2, n3, n4);
    }

    public Toggle addToggle(Object object, String string, String string2, boolean bl, float f, float f2, int n, int n2) {
        Toggle toggle = new Toggle(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string2, bl ? 1.0f : 0.0f, f, f2, n, n2);
        this.cp5.register(object, string, toggle);
        toggle.registerProperty("value");
        return toggle;
    }

    public Toggle addToggle(String string, boolean bl, float f, float f2, int n, int n2) {
        return this.addToggle(null, "", string, bl, f, f2, n, n2);
    }

    public Toggle addToggle(String string, float f, float f2, int n, int n2) {
        return this.addToggle(null, "", string, false, f, f2, n, n2);
    }

    public Toggle addToggle(Object object, String string, String string2, float f, float f2, int n, int n2) {
        return this.addToggle(object, string, string2, false, f, f2, n, n2);
    }

    public Tooltip addTooltip() {
        return null;
    }

    public Matrix addMatrix(Object object, String string, String string2, int n, int n2, int n3, int n4, int n5, int n6) {
        Matrix matrix = new Matrix(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string2, n, n2, n3, n4, n5, n6);
        this.cp5.register(object, string, matrix);
        ((Matrix)matrix.registerProperty("cells")).registerProperty("interval");
        return matrix;
    }

    public Matrix addMatrix(String string) {
        return this.addMatrix(string, 10, 10, 0, 0, 100, 100);
    }

    public Matrix addMatrix(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        return this.addMatrix(null, "", string, n, n2, n3, n4, n5, n6);
    }

    public Slider2D addSlider2D(String string) {
        return this.addSlider2D(string, 0, 0, 99, 99);
    }

    public Slider2D addSlider2D(Object object, String string, String string2, float f, float f2, float f3, float f4, float f5, float f6, int n, int n2, int n3, int n4) {
        Slider2D slider2D = new Slider2D(this.cp5, (ControllerGroup)this.cp5.controlWindow.getTabs().get(1), string2, n, n2, n3, n4);
        this.cp5.register(object, string, slider2D);
        slider2D.setMinX(f);
        slider2D.setMaxX(f2);
        slider2D.setMinY(f3);
        slider2D.setMaxY(f4);
        slider2D.setArrayValue(new float[]{f5, f6});
        slider2D.updateValue();
        ((Slider2D)((Slider2D)((Slider2D)((Slider2D)slider2D.registerProperty("arrayValue")).registerProperty("minX")).registerProperty("maxX")).registerProperty("minY")).registerProperty("maxY");
        return slider2D;
    }

    public Slider2D addSlider2D(String string, int n, int n2, int n3, int n4) {
        return this.addSlider2D(null, "", string, 0.0f, n3, 0.0f, n4, 0.0f, 0.0f, n, n2, n3, n4);
    }

    public Slider2D addSlider2D(Object object, String string, String string2, int n, int n2, int n3, int n4) {
        return this.addSlider2D(object, string, string2, 0.0f, n3, 0.0f, n4, 0.0f, 0.0f, n, n2, n3, n4);
    }

    public Slider2D addSlider2D(String string, float f, float f2, float f3, float f4, float f5, float f6, int n, int n2, int n3, int n4) {
        return this.addSlider2D(null, "", string, f, f2, f3, f4, f5, f6, n, n2, n3, n4);
    }

    public Slider addSlider(Object object, String string, String string2, float f, float f2, float f3, int n, int n2, int n3, int n4) {
        Slider slider = new Slider(this.cp5, (ControllerGroup)this.cp5.controlWindow.getTabs().get(1), string2, f, f2, f3, n, n2, n3, n4);
        this.cp5.register(object, string, slider);
        ((Slider)((Slider)slider.registerProperty("value")).registerProperty("min")).registerProperty("max");
        return slider;
    }

    public Slider addSlider(String string, float f, float f2, float f3, int n, int n2, int n3, int n4) {
        return this.addSlider(null, "", string, f, f2, f3, n, n2, n3, n4);
    }

    public Slider addSlider(String string, float f, float f2, int n, int n2, int n3, int n4) {
        return this.addSlider(null, "", string, f, f2, f, n, n2, n3, n4);
    }

    public Slider addSlider(Object object, String string, String string2, float f, float f2, int n, int n2, int n3, int n4) {
        return this.addSlider(object, string, string2, f, f2, f, n, n2, n3, n4);
    }

    public Range addRange(String string) {
        return this.addRange(string, 0.0f, 100.0f, 0.0f, 100.0f, 0, 0, 99, 9);
    }

    public Range addRange(Object object, String string, String string2, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        Range range = new Range(this.cp5, (ControllerGroup)this.cp5.controlWindow.getTabs().get(1), string2, f, f2, f3, f4, n, n2, n3, n4);
        this.cp5.register(object, string, range);
        ((Range)range.registerProperty("lowValue")).registerProperty("highValue");
        return range;
    }

    public Range addRange(String string, float f, float f2, float f3, float f4, int n, int n2, int n3, int n4) {
        return this.addRange(null, "", string, f, f2, f3, f4, n, n2, n3, n4);
    }

    public Range addRange(String string, float f, float f2, int n, int n2, int n3, int n4) {
        return this.addRange(null, "", string, f, f2, f, f2, n, n2, n3, n4);
    }

    public Range addRange(Object object, String string, String string2, float f, float f2, int n, int n2, int n3, int n4) {
        return this.addRange(object, string, string2, f, f2, f, f2, n, n2, n3, n4);
    }

    public Numberbox addNumberbox(Object object, String string, String string2, float f, int n, int n2, int n3, int n4) {
        Numberbox numberbox = new Numberbox(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string2, f, n, n2, n3, n4);
        this.cp5.register(object, string, numberbox);
        numberbox.registerProperty("value");
        return numberbox;
    }

    public Numberbox addNumberbox(String string, int n, int n2, int n3, int n4) {
        return this.addNumberbox(null, "", string, Float.NaN, n, n2, n3, n4);
    }

    public Numberbox addNumberbox(Object object, String string, String string2, int n, int n2, int n3, int n4) {
        return this.addNumberbox(object, string, string2, Float.NaN, n, n2, n3, n4);
    }

    public Numberbox addNumberbox(String string, float f, int n, int n2, int n3, int n4) {
        return this.addNumberbox(null, "", string, f, n, n2, n3, n4);
    }

    public Knob addKnob(Object object, String string, String string2, float f, float f2, float f3, int n, int n2, int n3) {
        Knob knob = new Knob(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string2, f, f2, f3, n, n2, n3);
        this.cp5.register(object, string, knob);
        knob.registerProperty("value");
        return knob;
    }

    public Knob addKnob(String string, float f, float f2, int n, int n2, int n3) {
        return this.addKnob(null, "", string, f, f2, f, n, n2, n3);
    }

    public Knob addKnob(Object object, String string, String string2, float f, float f2, int n, int n2, int n3) {
        return this.addKnob(object, string, string2, f, f2, n, n2, n3);
    }

    public Knob addKnob(String string, float f, float f2, float f3, int n, int n2, int n3) {
        return this.addKnob(null, "", string, f, f2, f3, n, n2, n3);
    }

    public MultiList addMultiList(Object object, String string, String string2, int n, int n2, int n3, int n4) {
        MultiList multiList = new MultiList(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string2, n, n2, n3, n4);
        this.cp5.register(object, string, multiList);
        multiList.registerProperty("value");
        return multiList;
    }

    public MultiList addMultiList(String string, int n, int n2, int n3, int n4) {
        return this.addMultiList(null, "", string, n, n2, n3, n4);
    }

    public Textlabel addTextlabel(String string) {
        return this.addTextlabel(string, "", 0, 0);
    }

    public Textlabel addTextlabel(Object object, String string, String string2, String string3, int n, int n2) {
        Textlabel textlabel = new Textlabel(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string2, string3, n, n2);
        this.cp5.register(object, string, textlabel);
        ((Textlabel)textlabel.registerProperty("value")).registerProperty("stringValue");
        return textlabel;
    }

    public Textlabel addTextlabel(String string, String string2, int n, int n2) {
        return this.addTextlabel(null, "", string, string2, n, n2);
    }

    public Textlabel addTextlabel(Object object, String string, String string2, String string3) {
        return this.addTextlabel(object, string, string2, string3, 0, 0);
    }

    public Textlabel addTextlabel(String string, String string2) {
        return this.addTextlabel(null, "", string, string2, 0, 0);
    }

    public Textarea addTextarea(String string) {
        return this.addTextarea(string, "", 0, 0, 199, 99);
    }

    public Textarea addTextarea(String string, String string2, int n, int n2, int n3, int n4) {
        Textarea textarea = new Textarea(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string, string2, n, n2, n3, n4);
        this.cp5.register(null, "", textarea);
        textarea.registerProperty("text");
        return textarea;
    }

    public Textfield addTextfield(String string) {
        return this.addTextfield(string, 0, 0, 199, 19);
    }

    public Textfield addTextfield(Object object, String string, String string2, int n, int n2, int n3, int n4) {
        Textfield textfield = new Textfield(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string2, "", n, n2, n3, n4);
        this.cp5.register(object, string, textfield);
        textfield.registerProperty("text");
        return textfield;
    }

    public Textfield addTextfield(String string, int n, int n2, int n3, int n4) {
        return this.addTextfield(null, "", string, n, n2, n3, n4);
    }

    public Textfield addTextfield(Object object, String string, String string2) {
        return this.addTextfield(object, string, string2, 0, 0, 99, 19);
    }

    public Accordion addAccordion(String string) {
        Accordion accordion = new Accordion(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string, 0, 0, 200);
        this.cp5.register(null, "", accordion);
        return accordion;
    }

    public Accordion addAccordion(String string, int n, int n2, int n3) {
        Accordion accordion = new Accordion(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string, n, n2, n3);
        this.cp5.register(null, "", accordion);
        return accordion;
    }

    public RadioButton addRadioButton(String string) {
        return this.addRadioButton(string, 0, 0);
    }

    public RadioButton addRadioButton(String string, int n, int n2) {
        RadioButton radioButton = new RadioButton(this.cp5, (ControllerGroup<?>)((Tab)this.cp5.controlWindow.getTabs().get(1)), string, n, n2);
        this.cp5.register(null, "", radioButton);
        radioButton.registerProperty("arrayValue");
        return radioButton;
    }

    public RadioButton addRadio(String string) {
        return this.addRadioButton(string, 0, 0);
    }

    public RadioButton addRadio(String string, int n, int n2) {
        RadioButton radioButton = new RadioButton(this.cp5, (ControllerGroup<?>)((Tab)this.cp5.controlWindow.getTabs().get(1)), string, n, n2);
        this.cp5.register(null, "", radioButton);
        radioButton.registerProperty("arrayValue");
        return radioButton;
    }

    public CheckBox addCheckBox(String string) {
        return this.addCheckBox(string, 0, 0);
    }

    public CheckBox addCheckBox(String string, int n, int n2) {
        CheckBox checkBox = new CheckBox(this.cp5, (ControllerGroup<?>)((Tab)this.cp5.controlWindow.getTabs().get(1)), string, n, n2);
        this.cp5.register(null, "", checkBox);
        checkBox.registerProperty("arrayValue");
        return checkBox;
    }

    public ListBox addListBox(String string) {
        return this.addListBox(string, 0, 0, 99, 199);
    }

    public ListBox addListBox(String string, int n, int n2, int n3, int n4) {
        ListBox listBox = new ListBox(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string, n, n2, n3, n4);
        this.cp5.register(null, "", listBox);
        ((ListBox)listBox.registerProperty("listBoxItems")).registerProperty("value");
        return listBox;
    }

    public DropdownList addDropdownList(String string) {
        return this.addDropdownList(string, 0, 0, 99, 99);
    }

    public DropdownList addDropdownList(String string, int n, int n2, int n3, int n4) {
        DropdownList dropdownList = new DropdownList(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string, n, n2, n3, n4);
        this.cp5.register(null, "", dropdownList);
        ((DropdownList)dropdownList.registerProperty("listBoxItems")).registerProperty("value");
        return dropdownList;
    }

    public ColorPicker addColorPicker(String string) {
        return this.addColorPicker(string, 0, 0, 255, 10);
    }

    public ColorPicker addColorPicker(String string, int n, int n2, int n3, int n4) {
        ColorPicker colorPicker = new ColorPicker(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string, n, n2, n3, n4);
        this.cp5.register(null, "", colorPicker);
        colorPicker.registerProperty("arrayValue");
        return colorPicker;
    }

    public Chart addChart(String string) {
        return this.addChart(string, 0, 0, 200, 100);
    }

    public Chart addChart(String string, int n, int n2, int n3, int n4) {
        Chart chart = new Chart(this.cp5, (Tab)this.cp5.controlWindow.getTabs().get(1), string, n, n2, n3, n4);
        this.cp5.register(null, "", chart);
        return chart;
    }

    public Group addGroup(Object object, String string, String string2, int n, int n2, int n3) {
        Group group = new Group(this.cp5, (ControllerGroup)this.cp5.controlWindow.getTabs().get(1), string2, n, n2, n3, 9);
        this.cp5.register(object, string, group);
        return group;
    }

    public Group addGroup(String string, int n, int n2, int n3) {
        return this.addGroup(null, "", string, n, n2, n3);
    }

    public Group addGroup(String string) {
        return this.addGroup(string, 0, 0);
    }

    public Group addGroup(String string, int n, int n2) {
        return this.addGroup(null, "", string, n, n2, 99);
    }

    public ControlWindow addControlWindow(String string, int n, int n2, int n3, int n4, String string2, int n5) {
        for (int i = 0; i < this.cp5.controlWindowList.size(); ++i) {
            if (!this.cp5.controlWindowList.get(i).name().equals(string)) continue;
            ControlP5.logger().warning("ControlWindow with name " + string + " already exists. overwriting now.");
        }
        PAppletWindow pAppletWindow = new PAppletWindow(this.cp5, string, n, n2, n3, n4, string2, n5);
        pAppletWindow.setParent(this.cp5);
        pAppletWindow.setMode(1);
        ControlWindow controlWindow = new ControlWindow(this.cp5, pAppletWindow);
        this.cp5.controlWindowList.add(controlWindow);
        return controlWindow;
    }

    public ControlWindow addControlWindow(String string, int n, int n2) {
        return this.addControlWindow(string, 100, 100, n, n2, "", 30);
    }

    public ControlWindow addControlWindow(String string, int n, int n2, int n3, int n4) {
        return this.addControlWindow(string, n, n2, n3, n4, "", 30);
    }

    public ControlWindow addControlWindow(String string, int n, int n2, int n3, int n4, int n5) {
        return this.addControlWindow(string, n, n2, n3, n4, "", n5);
    }

    public Textlabel getTextlabel(String string, int n, int n2) {
        return new Textlabel(this.cp5, string, n, n2);
    }

    public Textlabel getTextlabel() {
        return this.getTextlabel("", 0, 0);
    }

    protected void setCurrentPointer(ControllerGroup<?> controllerGroup) {
        this.currentGroupPointer = controllerGroup;
        this.isCurrentGroupPointerClosed = false;
    }

    protected void releaseCurrentPointer(ControllerGroup<?> controllerGroup) {
        if (!this.isCurrentGroupPointerClosed) {
            this.currentGroupPointer = controllerGroup;
            this.isCurrentGroupPointerClosed = true;
        } else {
            ControlP5.logger().warning("use .end() first before using .begin() again.");
        }
    }

    public void setAutoAddDirection(int n) {
        if (n == 0) {
            this.autoDirection = 0;
            return;
        }
        this.autoDirection = 1;
    }

    public void setAutoSpacing() {
        Controller.autoSpacing.x = 10.0f;
        Controller.autoSpacing.y = 10.0f;
        Controller.autoSpacing.z = 0.0f;
    }

    public void setAutoSpacing(float f) {
        Controller.autoSpacing.x = f;
    }

    public void setAutoSpacing(float f, float f2) {
        Controller.autoSpacing.x = f;
        Controller.autoSpacing.y = f2;
    }

    public void setAutoSpacing(float f, float f2, float f3) {
        Controller.autoSpacing.x = f;
        Controller.autoSpacing.y = f2;
        Controller.autoSpacing.z = f3;
    }

    protected void linebreak(Controller<?> controller, boolean bl, int n, int n2, PVector pVector) {
        if (this.currentGroupPointer.autoPosition.x + Controller.autoSpacing.x + (float)n > (float)this.cp5.papplet.width) {
            this.currentGroupPointer.autoPosition.y += this.currentGroupPointer.tempAutoPositionHeight;
            this.currentGroupPointer.autoPosition.x = this.currentGroupPointer.autoPositionOffsetX;
            this.currentGroupPointer.tempAutoPositionHeight = 0.0f;
            controller.position.x = this.currentGroupPointer.autoPosition.x;
            controller.position.y = this.currentGroupPointer.autoPosition.y;
            bl = false;
        }
        if (bl) {
            this.currentGroupPointer.autoPosition.y += this.currentGroupPointer.tempAutoPositionHeight;
            this.currentGroupPointer.autoPosition.x = this.currentGroupPointer.autoPositionOffsetX;
            this.currentGroupPointer.tempAutoPositionHeight = 0.0f;
        } else {
            if (controller instanceof Slider) {
                this.currentGroupPointer.autoPosition.x += (float)controller.getCaptionLabel().getWidth();
            }
            this.currentGroupPointer.autoPosition.x += Controller.autoSpacing.x + (float)n;
            if ((float)n2 + pVector.y > this.currentGroupPointer.tempAutoPositionHeight) {
                this.currentGroupPointer.tempAutoPositionHeight = (float)n2 + pVector.y;
            }
        }
    }

    public Slider addSlider(String string) {
        return this.addSlider(string, 0.0f, 100.0f);
    }

    public Slider addSlider(Object object, String string, String string2) {
        return this.addSlider(object, string, string2, 0.0f, 100.0f);
    }

    public Slider addSlider(String string, float f, float f2) {
        return this.addSlider(null, "", string, f, f2);
    }

    public Slider addSlider(Object object, String string, String string2, float f, float f2) {
        int n = (int)this.currentGroupPointer.autoPosition.x;
        int n2 = (int)this.currentGroupPointer.autoPosition.y;
        Slider slider = this.addSlider(object, string, string2, f, f2, f, n, n2, Slider.autoWidth, Slider.autoHeight);
        this.linebreak(slider, false, Slider.autoWidth, Slider.autoHeight, Slider.autoSpacing);
        slider.moveTo(this.currentGroupPointer);
        if (this.autoDirection == 1) {
            slider.linebreak();
        }
        return slider;
    }

    public Button addButton(String string) {
        return this.addButton(null, "", string, 1.0f);
    }

    public Button addButton(Object object, String string, String string2) {
        return this.addButton(object, string, string2, 1.0f);
    }

    public Button addButton(String string, float f) {
        return this.addButton(null, "", string, f);
    }

    public Button addButton(Object object, String string, String string2, float f) {
        int n = (int)this.currentGroupPointer.autoPosition.x;
        int n2 = (int)this.currentGroupPointer.autoPosition.y;
        Button button = this.addButton(object, string, string2, f, n, n2, Button.autoWidth, Button.autoHeight);
        this.linebreak(button, false, Button.autoWidth, Button.autoHeight, Button.autoSpacing);
        button.moveTo(this.currentGroupPointer);
        return button;
    }

    public Bang addBang(Object object, String string, String string2) {
        int n = (int)this.currentGroupPointer.autoPosition.x;
        int n2 = (int)this.currentGroupPointer.autoPosition.y;
        Bang bang = this.addBang(object, string, string2, n, n2, Bang.autoWidth, Bang.autoHeight);
        this.linebreak(bang, false, Bang.autoWidth, Bang.autoHeight, Bang.autoSpacing);
        bang.moveTo(this.currentGroupPointer);
        return bang;
    }

    public Toggle addToggle(String string) {
        return this.addToggle(null, "", string);
    }

    public Toggle addToggle(String string, boolean bl) {
        return this.addToggle(null, "", string, bl);
    }

    public Toggle addToggle(Object object, String string, String string2) {
        return this.addToggle(object, string, string2, false);
    }

    public Toggle addToggle(Object object, String string, String string2, boolean bl) {
        Toggle toggle = this.addToggle(object, string, string2, bl, this.currentGroupPointer.autoPosition.x, this.currentGroupPointer.autoPosition.y, Toggle.autoWidth, Toggle.autoHeight);
        this.linebreak(toggle, false, Toggle.autoWidth, Toggle.autoHeight, toggle.autoSpacing);
        toggle.moveTo(this.currentGroupPointer);
        return toggle;
    }

    public Numberbox addNumberbox(Object object, String string, String string2) {
        int n = (int)this.currentGroupPointer.autoPosition.x;
        int n2 = (int)this.currentGroupPointer.autoPosition.y;
        Numberbox numberbox = this.addNumberbox(object, string, string2, n, n2, Numberbox.autoWidth, Numberbox.autoHeight);
        this.linebreak(numberbox, false, Numberbox.autoWidth, Numberbox.autoHeight, numberbox.autoSpacing);
        numberbox.moveTo(this.currentGroupPointer);
        return numberbox;
    }

    public Numberbox addNumberbox(String string) {
        return this.addNumberbox(null, "", string);
    }

    public Knob addKnob(Object object, String string, String string2, int n, int n2) {
        Knob knob = this.addKnob(object, string, string2, n, n2, n, (int)this.currentGroupPointer.autoPosition.x, (int)this.currentGroupPointer.autoPosition.y, Knob.autoWidth);
        this.linebreak(knob, false, Knob.autoWidth, Knob.autoHeight, knob.autoSpacing);
        knob.moveTo(this.currentGroupPointer);
        return knob;
    }

    public Knob addKnob(String string) {
        return this.addKnob(string, 0, 100);
    }

    public Knob addKnob(Object object, String string, String string2) {
        return this.addKnob(object, string, string2, 0, 100);
    }

    public Knob addKnob(String string, int n, int n2) {
        return this.addKnob(null, "", string, n, n2);
    }

    public ControlWindow addControlWindow(String string) {
        return this.addControlWindow(string, 20, 20, 300, 400);
    }

    public <C> C addController(Object object, String string, String string2, Class<C> clazz, int n, int n2) {
        Controller controller = null;
        if (clazz.equals(Slider.class)) {
            controller = this.addSlider(object, string, string2, 0.0f, 100.0f, 0.0f, 0, 0, 99, 9);
        } else if (clazz.equals(Bang.class)) {
            controller = this.addBang(object, string, string2, 0, 0, 19, 19);
        } else if (clazz.equals(Button.class)) {
            controller = this.addButton(object, string, string2, 0.0f, 0, 0, 49, 19);
        } else if (clazz.equals(Knob.class)) {
            controller = this.addKnob(object, string, string2, 0.0f, 100.0f, 0.0f, 0, 0, 49);
        } else if (clazz.equals(Numberbox.class)) {
            controller = this.addNumberbox(object, string, string2, 0.0f, 0, 0, 99, 19);
        } else if (clazz.equals(Toggle.class)) {
            controller = this.addToggle(object, string, string2, false, 0.0f, 0.0f, 49, 19);
        } else if (clazz.equals(Textfield.class)) {
            controller = this.addTextfield(object, string, string2, 0, 0, 99, 19);
        } else if (clazz.equals(Range.class)) {
            controller = this.addRange(object, string, string2, 0.0f, 100.0f, 0.0f, 100.0f, 0, 0, 99, 9);
        } else if (clazz.equals(Slider2D.class)) {
            controller = this.addSlider2D(object, string, string2, 0.0f, 100.0f, 0.0f, 100.0f, 0.0f, 0.0f, 0, 0, 99, 99);
        } else if (clazz.equals(Textlabel.class)) {
            controller = this.addTextlabel(string2, "<empty>");
        }
        controller.setPosition(n, n2);
        return (C)controller;
    }

    @ControlP5.Invisible
    public <C> C addGroup(Object object, String string, String string2, Class<C> clazz, int n, int n2, int n3, int n4) {
        ControlGroup controlGroup = null;
        if (clazz.equals(DropdownList.class)) {
            controlGroup = this.addDropdownList(string2, n, n2, n3, n4);
        } else if (clazz.equals(ListBox.class)) {
            controlGroup = this.addListBox(string2, n, n2, n3, n4);
        } else if (clazz.equals(ListBox.class)) {
            controlGroup = this.addListBox(string2, n, n2, n3, n4);
        } else if (clazz.equals(RadioButton.class)) {
            controlGroup = this.addRadioButton(string2, n, n2);
        } else if (clazz.equals(CheckBox.class)) {
            controlGroup = this.addCheckBox(string2, n, n2);
        } else if (clazz.equals(ControlGroup.class)) {
            controlGroup = this.addGroup(string2, n, n2);
        } else if (clazz.equals(Group.class)) {
            controlGroup = this.addGroup(string2, n, n2);
        }
        controlGroup.setPosition(n, n2);
        ((ControllerGroup)controlGroup).setWidth(n3);
        ((ControllerGroup)controlGroup).setHeight(n4);
        return (C)controlGroup;
    }

    public <C> C addController(String string, Class<C> clazz, int n, int n2) {
        return this.addController(null, "", string, clazz, n, n2);
    }

    public ControlP5Base addControllersFor(PApplet pApplet) {
        this.addControllersFor("", pApplet);
        return this;
    }

    public ControlP5Base addControllersFor(String string, Object object) {
        this._myAutomator.addControllersFor(string, object);
        return this;
    }

    public Controller<?> getController(String string, Object object) {
        if (this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                if (!controllerInterface.getName().equals(string)) continue;
                return (Controller)controllerInterface;
            }
        }
        return null;
    }

    public Object getObjectForController(ControllerInterface controllerInterface) {
        for (Map.Entry<Object, ArrayList<ControllerInterface<?>>> entry : this._myObjectToControllerMap.entrySet()) {
            Object object = entry.getKey();
            ArrayList<ControllerInterface<?>> arrayList = entry.getValue();
            for (ControllerInterface<?> controllerInterface2 : arrayList) {
                if (!controllerInterface2.equals(controllerInterface)) continue;
                return object;
            }
        }
        return null;
    }

    public ControlP5Base setPosition(int n, int n2, Object object) {
        if (object != null && this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                int n3 = (int)controllerInterface.getPosition().x + n;
                int n4 = (int)controllerInterface.getPosition().y + n2;
                controllerInterface.setPosition(n3, n4);
            }
        }
        return this;
    }

    public ControlP5Base hide(Object object) {
        if (object != null && this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                controllerInterface.hide();
            }
        }
        return this;
    }

    public ControlP5Base show(Object object) {
        if (object != null && this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                controllerInterface.show();
            }
        }
        return this;
    }

    public ControlP5Base remove(Object object) {
        if (object != null && this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                controllerInterface.remove();
            }
        }
        return this;
    }

    public ControlP5Base setColor(CColor cColor, Object object) {
        if (this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                controllerInterface.setColor(cColor);
            }
        }
        return this;
    }

    public ControlP5Base listenTo(String string, Object object) {
        String string2 = object.hashCode() + "" + string.hashCode();
        FieldChangedListener fieldChangedListener = new FieldChangedListener(this.cp5);
        fieldChangedListener.listenTo(object, string);
        this._myFieldChangedListenerMap.put(string2, fieldChangedListener);
        return this;
    }

    public ControlP5Base stopListeningTo(String string, Object object) {
        String string2 = object.hashCode() + "" + string.hashCode();
        this._myFieldChangedListenerMap.remove(string2);
        return this;
    }

    public ControlP5Base moveTo(ControllerGroup<?> controllerGroup, Object object) {
        if (this._myObjectToControllerMap.containsKey(object)) {
            ArrayList<ControllerInterface<?>> arrayList = this._myObjectToControllerMap.get(object);
            for (ControllerInterface<?> controllerInterface : arrayList) {
                controllerInterface.moveTo(controllerGroup);
            }
        }
        return this;
    }

    public ControllerProperties getProperties() {
        return this._myProperties;
    }

    public void removeProperty(ControllerInterface<?> controllerInterface) {
        this._myProperties.remove(controllerInterface);
    }

    public static void printPublicMethodsFor(Class<?> clazz, String ... stringArray) {
        Set<String> set = ControlP5Base.getPublicMethodsFor(clazz, true, stringArray);
        String string = "";
        string = string + "/**\n";
        string = string + "* ControlP5 " + clazz.getSimpleName() + "\n";
        string = string + "*\n";
        string = string + "*\n";
        string = string + "* find a list of public methods available for the " + clazz.getSimpleName() + " Controller\n";
        string = string + "* at the bottom of this sketch.\n";
        string = string + "*\n";
        string = string + "* by Andreas Schlegel, 2012\n";
        string = string + "* www.sojamo.de/libraries/controlp5\n";
        string = string + "*\n";
        string = string + "*/\n\n";
        string = string + "/*\n";
        string = string + "a list of all methods available for the " + clazz.getSimpleName() + " Controller\n";
        string = string + "use ControlP5.printPublicMethodsFor(" + clazz.getSimpleName() + ".class);\n";
        string = string + "to print the following list into the console.\n\n";
        string = string + "You can find further details about class " + clazz.getSimpleName() + " in the javadoc.\n\n";
        string = string + "Format:\n";
        string = string + "ClassName : returnType methodName(parameter type)\n\n\n";
        for (String string2 : set) {
            string = string + string2 + "\n";
        }
        string = string + "\n\n*/\n\n";
        System.out.println(string);
    }

    public static void printPublicMethodsFor(Class<?> clazz) {
        ControlP5Base.printPublicMethodsFor(clazz, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> clazz) {
        return ControlP5Base.getPublicMethodsFor(clazz, true, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> clazz, String ... stringArray) {
        return ControlP5Base.getPublicMethodsFor(clazz, true, stringArray);
    }

    public static Set<String> getPublicMethodsFor(Class<?> clazz, boolean bl) {
        return ControlP5Base.getPublicMethodsFor(clazz, true, "");
    }

    public static Set<String> getPublicMethodsFor(Class<?> clazz, boolean bl, String ... stringArray) {
        TreeSet<String> treeSet = new TreeSet<String>();
        Class<?> clazz2 = clazz;
        while (clazz2 != null) {
            for (Method method : clazz2.getDeclaredMethods()) {
                if (method.isAnnotationPresent(Deprecated.class) || method.isAnnotationPresent(ControlP5.Invisible.class) || method.getModifiers() != 1) continue;
                for (String string : stringArray) {
                    if (string.length() > 0 && !method.getName().toLowerCase().contains(string.toLowerCase())) continue;
                    String string2 = "";
                    for (Class<?> clazz3 : method.getParameterTypes()) {
                        string2 = string2 + clazz3.getSimpleName() + ", ";
                    }
                    if (string2.length() > 0) {
                        string2 = string2.substring(0, string2.length() - 2);
                    }
                    treeSet.add(clazz2.getCanonicalName() + " : " + method.getReturnType().getSimpleName().replace("Object", clazz.getSimpleName()) + " " + method.getName() + "(" + string2 + ") ");
                }
            }
            if (bl) {
                clazz2 = clazz2.getSuperclass();
                continue;
            }
            clazz2 = null;
        }
        return treeSet;
    }

    public ControlP5 mapKeyFor(ControlKey controlKey, int ... nArray) {
        char[] cArray = this.fromIntToChar(nArray);
        this.cp5.keyHandler.mapKeyFor(controlKey, cArray);
        this.cp5.enableShortcuts();
        return this.cp5;
    }

    private char[] fromIntToChar(int ... nArray) {
        char[] cArray = new char[nArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            if (nArray[i] >= 97 && nArray[i] <= 122) {
                int n = i;
                nArray[n] = nArray[n] - 32;
            }
            cArray[i] = (char)nArray[i];
        }
        return cArray;
    }

    public ControlP5 removeKeyFor(ControlKey controlKey, int ... nArray) {
        this.cp5.keyHandler.removeKeyFor(controlKey, this.fromIntToChar(nArray));
        return this.cp5;
    }

    public ControlP5 removeKeysFor(int ... nArray) {
        this.cp5.keyHandler.removeKeysFor(this.fromIntToChar(nArray));
        return this.cp5;
    }
}

