/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.URL;
import java.net.URLEncoder;
import java.text.StringCharacterIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ControlP5IOHandler {
    ControlP5 cp5;
    String _myFilePath;
    String _myUrlPath;
    boolean isLock;
    private static final String fSTART_CHAR = "[";
    private static final String fEND_CHAR = "]";
    private static final String fSEPARATOR = ", ";
    private static final String fNULL = "null";

    public ControlP5IOHandler(ControlP5 controlP5) {
        this.cp5 = controlP5;
    }

    public static String forURL(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 not supported", unsupportedEncodingException);
        }
        return string2;
    }

    public static String forHTMLTag(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else if (c == '\'') {
                stringBuffer.append("&#039;");
            } else if (c == '\\') {
                stringBuffer.append("&#092;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    String URLEncode(String string) {
        String string2 = new String();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] < 0) continue;
                string2 = byArray[i] == 32 ? string2 + '+' : string2 + (char)byArray[i];
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return string2;
    }

    public static String replace(String string, String string2, String string3) {
        if (string.length() < 1) {
            return "";
        }
        for (int i = 0; i < string.length() && (i = string.indexOf(string2, i)) >= 0; i += string3.length()) {
            string = string.substring(0, i) + string3 + string.substring(i + string2.length(), string.length());
        }
        return string;
    }

    public static int parseHex(String string) {
        int n = string.length();
        switch (n) {
            case 8: {
                break;
            }
            case 6: {
                string = "ff" + string;
                break;
            }
            default: {
                string = "ff000000";
            }
        }
        int n2 = new Integer(Integer.parseInt(string.substring(0, 2), 16));
        int n3 = new Integer(Integer.parseInt(string.substring(2, 4), 16));
        int n4 = new Integer(Integer.parseInt(string.substring(4, 6), 16));
        int n5 = new Integer(Integer.parseInt(string.substring(6, 8), 16));
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static String intToString(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n >> 0 & 0xFF;
        String string = Integer.toHexString(n2).length() == 1 ? "0" + Integer.toHexString(n2) : Integer.toHexString(n2);
        String string2 = Integer.toHexString(n3).length() == 1 ? "0" + Integer.toHexString(n3) : Integer.toHexString(n3);
        String string3 = Integer.toHexString(n4).length() == 1 ? "0" + Integer.toHexString(n4) : Integer.toHexString(n4);
        String string4 = Integer.toHexString(n5).length() == 1 ? "0" + Integer.toHexString(n5) : Integer.toHexString(n5);
        return string + string2 + string3 + string4;
    }

    @Deprecated
    protected boolean save(ControlP5 controlP5, String string) {
        ControlP5.logger().info("Saving ControlP5 settings in XML format has been removed, have a look at controlP5's properties instead.");
        return false;
    }

    public static String arrayToString(Object object) {
        if (object == null) {
            return fNULL;
        }
        ControlP5IOHandler.checkObjectIsArray(object);
        StringBuilder stringBuilder = new StringBuilder(fSTART_CHAR);
        int n = Array.getLength(object);
        for (int i = 0; i < n; ++i) {
            Object object2 = Array.get(object, i);
            if (ControlP5IOHandler.isNonNullArray(object2)) {
                stringBuilder.append(ControlP5IOHandler.arrayToString(object2));
            } else {
                stringBuilder.append(object2);
            }
            if (ControlP5IOHandler.isLastItem(i, n)) continue;
            stringBuilder.append(fSEPARATOR);
        }
        stringBuilder.append(fEND_CHAR);
        return stringBuilder.toString();
    }

    private static void checkObjectIsArray(Object object) {
        if (!object.getClass().isArray()) {
            throw new IllegalArgumentException("Object is not an array.");
        }
    }

    private static boolean isNonNullArray(Object object) {
        return object != null && object.getClass().isArray();
    }

    private static boolean isLastItem(int n, int n2) {
        return n == n2 - 1;
    }

    protected static String formatGetClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return clazz.toString().startsWith("class ") ? clazz.toString().substring("class ".length()) : clazz.toString();
    }

    @Deprecated
    public Image loadImage2(URL uRL) {
        return this.loadImage((Component)this.cp5.papplet, uRL);
    }

    @Deprecated
    public Image loadImage(Component component, URL uRL) {
        if (component == null) {
            component = this.cp5.papplet;
        }
        Image image = null;
        image = Toolkit.getDefaultToolkit().createImage(uRL);
        MediaTracker mediaTracker = new MediaTracker(component);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            ControlP5.logger().severe("loading image failed." + interruptedException.toString());
        }
        catch (Exception exception) {
            ControlP5.logger().severe("loading image failed." + exception.toString());
        }
        return image;
    }
}

