/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CRect;
import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.MultiListButton;
import controlP5.MultiListInterface;
import controlP5.Tab;
import java.util.ArrayList;
import java.util.List;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiList
extends Controller<MultiList>
implements MultiListInterface,
ControlListener {
    protected Tab _myTab;
    protected boolean isVisible = true;
    private int cnt;
    protected boolean isOccupied;
    protected boolean isUpdateLocation = false;
    protected MultiListInterface mostRecent;
    protected CRect _myRect;
    protected int _myDirection = 39;
    public int closeDelay = 30;
    protected int _myDefaultButtonHeight = 10;
    protected boolean isUpperCase = true;

    public MultiList(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0, 0, 99, 19);
        controlP5.register(controlP5.papplet, string, this);
    }

    public MultiList(ControlP5 controlP5, Tab tab, String string, int n, int n2, int n3, int n4) {
        super(controlP5, tab, string, n, n2, n3, 0);
        this._myDefaultButtonHeight = n4;
        this.setup();
    }

    @Override
    public MultiList toUpperCase(boolean bl) {
        this.isUpperCase = bl;
        for (Controller<?> controller : this.getSubelements()) {
            controller.getCaptionLabel().toUpperCase(this.isUpperCase);
        }
        return this;
    }

    @ControlP5.Invisible
    public void setup() {
        this.mostRecent = this;
        this.isVisible = true;
        this.updateRect(this.position.x, this.position.y, this.width, this._myDefaultButtonHeight);
    }

    protected void updateRect(float f, float f2, float f3, float f4) {
        this._myRect = new CRect(f, f2, f3, f4);
    }

    @Override
    public int getDirection() {
        return this._myDirection;
    }

    void setDirection(int n) {
        this._myDirection = n == 37 ? 37 : 39;
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListButton)this.getSubelements().get(i)).setDirection(this._myDirection);
        }
    }

    @Override
    @ControlP5.Invisible
    public void updateLocation(float f, float f2) {
        this.position.x += f;
        this.position.y += f2;
        this.updateRect(this.position.x, this.position.y, this.width, this._myDefaultButtonHeight);
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListInterface)((Object)this.getSubelements().get(i))).updateLocation(f, f2);
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            this.getSubelements().get(i).removeListener(this);
            this.getSubelements().get(i).remove();
        }
    }

    public MultiListButton add(String string, int n) {
        int n2 = (int)this.position.x;
        int n3 = 0;
        for (Controller<?> multiListButton2 : this.getSubelements()) {
            n3 += multiListButton2.getHeight() + 1;
        }
        int n4 = (int)this.position.y + n3;
        MultiListButton multiListButton = new MultiListButton(this.cp5, string, n, n2, n4, this.width, this._myDefaultButtonHeight, this, this);
        multiListButton.toUpperCase(this.isUpperCase);
        multiListButton.isMoveable = false;
        this.cp5.register(null, "", multiListButton);
        multiListButton.addListener(this);
        this.getSubelements().add(multiListButton);
        multiListButton.show();
        this.updateRect(this.position.x, this.position.y, this.width, (this._myDefaultButtonHeight + 1) * this.getSubelements().size());
        return multiListButton;
    }

    @Override
    @ControlP5.Invisible
    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.getController() instanceof MultiListButton) {
            this._myValue = controlEvent.getController().getValue();
            ControlEvent controlEvent2 = new ControlEvent(this);
            this.cp5.getControlBroadcaster().broadcast(controlEvent2, 2);
        }
    }

    @Override
    @ControlP5.Invisible
    public void draw(PApplet pApplet) {
        super.draw(pApplet);
        this.update(pApplet);
    }

    @ControlP5.Invisible
    public boolean update(PApplet pApplet) {
        if (!this.isOccupied) {
            ++this.cnt;
            if (this.cnt == this.closeDelay) {
                this.close();
            }
        }
        if (this.isUpdateLocation) {
            this.updateLocation(this._myControlWindow.mouseX - this._myControlWindow.pmouseX, this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
            this.isUpdateLocation = pApplet.mousePressed;
        }
        if (this.isOccupied && pApplet.keyPressed && pApplet.mousePressed && pApplet.keyCode == 18) {
            this.isUpdateLocation = true;
            return true;
        }
        return false;
    }

    @ControlP5.Invisible
    public void occupied(boolean bl) {
        this.isOccupied = bl;
        this.cnt = 0;
    }

    @Override
    @ControlP5.Invisible
    public boolean observe() {
        return CRect.inside(this._myRect, this._myControlWindow.mouseX, this._myControlWindow.mouseY);
    }

    @Override
    public void close(MultiListInterface multiListInterface) {
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            if (multiListInterface == (MultiListInterface)((Object)this.getSubelements().get(i))) continue;
            ((MultiListInterface)((Object)this.getSubelements().get(i))).close();
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListInterface)((Object)this.getSubelements().get(i))).close();
        }
    }

    @Override
    public void open() {
        for (int i = 0; i < this.getSubelements().size(); ++i) {
            ((MultiListInterface)((Object)this.getSubelements().get(i))).open();
        }
    }

    @Override
    public MultiList setValue(float f) {
        return this;
    }

    @Override
    public MultiList update() {
        return this.setValue(this._myValue);
    }

    @Deprecated
    public List<MultiListButton> subelements() {
        System.out.println("controlP5.MultiList.subelements() is deprecated since 0.7.6, use getSubelements().\nFor convenience an empty List is returned here.");
        return new ArrayList<MultiListButton>();
    }

    @Deprecated
    public List<MultiListButton> getChildren() {
        System.out.println("controlP5.MultiList.getChildren() is deprecated since 0.7.6, use getSubelements().\nFor convenience an empty List is returned here.");
        return new ArrayList<MultiListButton>();
    }
}

