/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.ControlWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import processing.core.PApplet;

class PAppletWindow
extends PApplet
implements WindowListener,
ComponentListener {
    private static final long serialVersionUID = -1773456691122668251L;
    protected int width = 600;
    protected int height = 200;
    protected int x = 100;
    protected int y = 100;
    protected String _myName;
    protected String _myTitle;
    protected boolean isCoordinates = true;
    protected boolean isLoop = true;
    protected ControlWindow controlWindow;
    protected ControlP5 controlP5;
    public static final int NORMAL = 0;
    public static final int ECONOMIC = 1;
    protected int _myMode = 0;
    protected String _myRenderer = "";
    protected int _myFrameRate = 30;
    private final ControlP5 cp5;

    public PAppletWindow(ControlP5 controlP5) {
        this.cp5 = controlP5;
    }

    public PAppletWindow(ControlP5 controlP5, String string, int n, int n2) {
        this(controlP5, string, n, n2, "", 30);
    }

    public PAppletWindow(ControlP5 controlP5, String string, int n, int n2, String string2, int n3) {
        this.cp5 = controlP5;
        this._myName = string;
        this._myTitle = string;
        this.width = n;
        this.height = n2;
        this._myFrameRate = n3;
        this._myRenderer = string2;
        this.launch();
    }

    public PAppletWindow(ControlP5 controlP5, String string, int n, int n2, int n3, int n4) {
        this(controlP5, string, n, n2, n3, n4, "", 30);
    }

    public PAppletWindow(ControlP5 controlP5, String string, int n, int n2, int n3, int n4, String string2, int n5) {
        this.cp5 = controlP5;
        this._myName = string;
        this._myTitle = string;
        this.width = n3;
        this.height = n4;
        this.x = n;
        this.y = n2;
        this._myFrameRate = n5;
        this._myRenderer = string2;
        this.launch();
    }

    public void setParent(ControlP5 controlP5) {
        this.controlP5 = controlP5;
    }

    public void pause() {
        this.controlWindow.isAutoDraw = false;
    }

    public void play() {
        this.controlWindow.isAutoDraw = true;
    }

    public String name() {
        return this._myName;
    }

    protected void visible(boolean bl) {
        if (bl) {
            this.frame.show();
        } else {
            this.frame.hide();
        }
    }

    protected void resizeable(boolean bl) {
        this.frame.setResizable(bl);
    }

    public void setup() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this._myRenderer.length() == 0) {
            this.size(this.width, this.height);
        } else {
            this.size(this.width, this.height, this._myRenderer);
            ControlP5.logger().finer("ControlWindow: using renderer " + this._myRenderer);
        }
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.frameRate(this._myFrameRate);
    }

    protected void setControlWindow(ControlWindow controlWindow) {
        this.controlWindow = controlWindow;
    }

    public void draw() {
    }

    public void setTitle(String string) {
        this._myTitle = string;
        this.updateTitle();
    }

    protected void updateTitle() {
        String string = this._myTitle;
        if (this.isCoordinates) {
            string = string + " x:" + this.x + " y:" + this.y + "   " + this.width + "x" + this.height;
        }
        this.frame.setTitle(string);
    }

    public String title() {
        return this._myTitle;
    }

    public void showCoordinates() {
        this.isCoordinates = true;
        this.updateTitle();
    }

    public void hideCoordinates() {
        this.isCoordinates = false;
        this.updateTitle();
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.isLoop = true;
        this.loop();
        try {
            this.controlP5.deactivateControllers();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.cp5.papplet.keyPressed(keyEvent);
        this.cp5.keyHandler.keyEvent(keyEvent, this.controlWindow, false);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.cp5.papplet.keyReleased(keyEvent);
        this.cp5.keyHandler.keyEvent(keyEvent, this.controlWindow, false);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.cp5.papplet.keyTyped(keyEvent);
        this.cp5.keyHandler.keyEvent(keyEvent, this.controlWindow, false);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.controlWindow.remove();
        this.controlWindow._myApplet.stop();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        if (this._myMode == 1) {
            this.isLoop = false;
            this.noLoop();
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Component component = componentEvent.getComponent();
        this.x = component.getLocation().x;
        this.y = component.getLocation().y;
        this.updateTitle();
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void setMode(int n) {
        if (n == 1) {
            this._myMode = 1;
            return;
        }
        this._myMode = 0;
    }

    public void dispose() {
        this.controlWindow._myApplet.stop();
        this.stop();
        this.removeAll();
        this.frame.removeAll();
        this.frame.dispose();
    }

    private void launch() {
        Object object;
        GraphicsDevice graphicsDevice = null;
        if (graphicsDevice == null) {
            object = GraphicsEnvironment.getLocalGraphicsEnvironment();
            graphicsDevice = ((GraphicsEnvironment)object).getDefaultScreenDevice();
        }
        this.frame = new Frame(graphicsDevice.getDefaultConfiguration());
        this.frame.setResizable(false);
        this.init();
        this.frame.pack();
        this.frame.setLocation(this.x, this.y);
        object = this.frame.getInsets();
        int n = Math.max(this.width, 128) + ((Insets)object).left + ((Insets)object).right;
        int n2 = Math.max(this.height, 128) + ((Insets)object).top + ((Insets)object).bottom;
        this.frame.setSize(n, n2);
        this.frame.setLayout(null);
        this.frame.add((Component)((Object)this));
        this.frame.setBackground(Color.black);
        int n3 = n2 - ((Insets)object).top - ((Insets)object).bottom;
        this.setBounds((n - this.width) / 2, ((Insets)object).top + (n3 - this.height) / 2, this.width, this.height);
        this.frame.addWindowListener(this);
        this.frame.addComponentListener(this);
        this.frame.setName(this._myName);
        this.frame.setTitle(this._myName + " x:" + this.x + " y:" + this.y + "   w:" + this.width + " h:" + this.height);
        this.frame.setVisible(true);
        this.requestFocus();
    }
}

