/*
 *  Copyright (C) 1999 AT&T Laboratories Cambridge.  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

/*
 * hextile.c - handle hextile encoding.
 *
 * This file shouldn't be compiled directly.  It is included multiple times by
 * rfbproto.c, each time with a different definition of the macro BPP.  For
 * each value of BPP, this file defines a function which handles a hextile
 * encoded rectangle with BPP bits per pixel.
 */

#define HandleHextileBPPToBPPC CONCAT2E(CONCAT2E(HandleHextile,BPP),CONCAT2E(To,BPPC))
#define changePixelFormatBPPToBPPC CONCAT2E(CONCAT2E(changePixelFormat,BPP),CONCAT2E(To,BPPC))
#define CARDBPP CONCAT2E(CARD,BPP)
#define CARDBPPC CONCAT2E(CARD,BPPC)
#define GET_PIXEL CONCAT2E(GET_PIXEL,BPP)

Bool
HandleHextileBPPToBPPC (int rx, int ry, int rw, int rh)
{
  CARDBPP serv_bg, serv_fg;
  CARDBPPC bg, fg;
  int i;
  CARD8 *ptr;
  int x, y, w, h;
  int sx, sy, sw, sh;
  CARD8 subencoding;
  CARD8 nSubrects;
  CARD8 tmp_buf[BUFFER_SIZE];
  int buf_size;

  GdkGCValues gdkgcv;

  for (y = ry; y < ry+rh; y += 16) {
    for (x = rx; x < rx+rw; x += 16) {
      w = h = 16;
      if (rx+rw - x < 16)
	w = rx+rw - x;
      if (ry+rh - y < 16)
	h = ry+rh - y;

      if (!ReadFromMultiVNCServer((char *)&subencoding, 1))
	return False;
      if (subencoding & rfbHextileRaw) {
#if (BPP == BPPC)
	if (!ReadFromMultiVNCServer(buffer, w * h * (BPP / 8)))
	  return False;
#else
	buf_size = w * h * (BPP / 8);
	if (!ReadFromMultiVNCServer((char *)tmp_buf, buf_size))
	  return False;
	if (changePixelFormatBPPToBPPC((char *)tmp_buf, buf_size, buffer) == -1)
	  return False;
#endif

	CopyDataToScreenForClient(buffer, x, y, w, h);

	continue;
      }

      if (subencoding & rfbHextileBackgroundSpecified) {
#if (BPP == BPPC)
	if (!ReadFromMultiVNCServer((char *)&bg, sizeof(bg)))
	  return False;
#else
	if (!ReadFromMultiVNCServer((char *)&serv_bg, sizeof(serv_bg)))
	  return False;
	if (changePixelFormatBPPToBPPC((char *)&serv_bg, sizeof(serv_bg), (char *)&bg) == -1)
	  return False;
#endif
      }

#if (BPPC == 8)
      if (appData.useBGR233)
	gdkgcv.foreground.pixel = BGR233ToPixel[bg];
      else
#endif
	gdkgcv.foreground.pixel = bg;

      gdk_gc_set_foreground(gdkGC, &gdkgcv.foreground);
      draw_rectangle_for_client(gdkpixmap[0][0], gdkGC, TRUE, x, y, w, h, gdkgcv.foreground.pixel);

      if (subencoding & rfbHextileForegroundSpecified) {
#if (BPP == BPPC)
	if (!ReadFromMultiVNCServer((char *)&fg, sizeof(fg)))
	  return False;
#else
	if (!ReadFromMultiVNCServer((char *)&serv_fg, sizeof(serv_fg)))
	  return False;
	if (changePixelFormatBPPToBPPC((char *)&serv_fg, sizeof(serv_fg), (char *)&fg) == -1)
	  return False;
#endif
      }

      if (!(subencoding & rfbHextileAnySubrects)) {
	continue;
      }

      if (!ReadFromMultiVNCServer((char *)&nSubrects, 1))
	return False;

      ptr = (CARD8 *)buffer;

      if (subencoding & rfbHextileSubrectsColoured) {
	if (!ReadFromMultiVNCServer(buffer, nSubrects * (2 + (BPP / 8))))
	  return False;

	for (i = 0; i < nSubrects; i++) {
#if (BPP == BPPC)
	  GET_PIXEL(fg, ptr);
#else
	  GET_PIXEL(serv_fg, ptr);
	  if (changePixelFormatBPPToBPPC((char *)&serv_fg, sizeof(serv_fg), (char *)&fg) == -1)
	    return False;
#endif
	  sx = rfbHextileExtractX(*ptr);
	  sy = rfbHextileExtractY(*ptr);
	  ptr++;
	  sw = rfbHextileExtractW(*ptr);
	  sh = rfbHextileExtractH(*ptr);
	  ptr++;
#if (BPPC == 8)
	  if (appData.useBGR233)
	    gdkgcv.foreground.pixel = BGR233ToPixel[fg];
	  else
#endif
	    gdkgcv.foreground.pixel = fg;

          gdk_gc_set_foreground(gdkGC, &gdkgcv.foreground);
	  draw_rectangle_for_client(gdkpixmap[0][0], gdkGC, TRUE, x+sx, y+sy, sw, sh, gdkgcv.foreground.pixel);
	}

      } else {
	if (!ReadFromMultiVNCServer(buffer, nSubrects * 2))
	  return False;

#if (BPPC == 8)
	if (appData.useBGR233)
	  gdkgcv.foreground.pixel = BGR233ToPixel[fg];
	else
#endif
	  gdkgcv.foreground.pixel = fg;

        gdk_gc_set_foreground(gdkGC, &gdkgcv.foreground);

	for (i = 0; i < nSubrects; i++) {
	  sx = rfbHextileExtractX(*ptr);
	  sy = rfbHextileExtractY(*ptr);
	  ptr++;
	  sw = rfbHextileExtractW(*ptr);
	  sh = rfbHextileExtractH(*ptr);
	  ptr++;

	  draw_rectangle_for_client(gdkpixmap[0][0], gdkGC, TRUE, x+sx, y+sy, sw, sh, gdkgcv.foreground.pixel);
	}
      }
    }
  }
  
  return True;
}

