#ifndef IMAGE_PROCESSING_H
#define IMAGE_PROCESSING_H

/*//macro*/
#if 1
#define dbg(...) (fprintf(stderr, "@@debug :: %s %u@%s:",__FILE__,__LINE__,__func__),fprintf(stderr, ""__VA_ARGS__),fprintf(stderr, "\n"))
#else
#define dbg(...)
#endif
#define err(...) (fprintf(stderr, "@@error :: %s %u@%s:%s:",__FILE__,__LINE__,__func__,strerror(errno)),fprintf(stderr, ""__VA_ARGS__),fprintf(stderr, "\n"))


#define C_INTERVAL 60
#define S_INTERVAL 60
#define LENGTH_TIME_SEQ 10

#define MAX_HIST 256
#define NORMALIZE_HIST 76800

//#define MAX_CLIENT 50
#define MATCHING_RATIO 0.95


typedef struct time_sequence
{
    int now;
    int length;
} TS;

#if 0
struct client_cb
{
    int hist_h[MAX_HIST];
    int flag;
};
#endif


extern Display *display;
extern pthread_mutex_t i_mutex;
extern pthread_t i_thread;


void RGBtoHSV(int r,int g,int b,int *h,int *s,int *v);

void tsInit(TS *ts,int length);
void tsPutForward(TS *ts);
int tsFromNow(TS *ts,int diff);
int tsNext(TS *ts,int time);
int tsPrev(TS *ts,int time);

extern void *image_proc_server (void *arg);
extern void *image_proc_client (void *arg);

#endif
