#!/bin/bash

build_vncviewer() {
	cd ./vncviewer
	./build.sh
	make
	RC=$?
	if [ $RC -ne 0 ]; then
		exit
	else
		echo "********** vncviewer done **********"
	fi
	cd -
}

build_client() {
	cd ./src_client
    ./autogen.sh
	make
	RC=$?
	if [ $RC -ne 0 ]; then
		exit
	else
		echo "********** client done **********"
	fi
	cd -
	cp ./src_client/src/multivnc_client .
}

build_server() {
	cd ./src_server
    ./autogen.sh
	make
	RC=$?
	if [ $RC -ne 0 ]; then
		exit
	else
		echo "********** server done **********"
	fi
	cd -
	cp ./src_server/src/multivnc_server .
}

case $1 in
	client)
		build_vncviewer
		build_client
		;;
	server)
		build_vncviewer
		build_server
		;;
	all)
		build_vncviewer
		build_client
		build_server
		;;
	*)
		build_vncviewer
		build_client
		build_server
		;;
esac

