#!/bin/bash

TARGET=$1
DESTDIR=$2

install_client() {
	mkdir -p $DESTDIR/usr/bin/
	cp -f multivnc_client $DESTDIR/usr/bin/.

	mkdir -p $DESTDIR/usr/share/locale/ja/LC_MESSAGES/
	cp -f src_client/po/ja.mo $DESTDIR/usr/share/locale/ja/LC_MESSAGES/multivnc_client.mo
	mkdir -p $DESTDIR/usr/share/locale/zh_CN/LC_MESSAGES/
	cp -f src_client/po/zh_CN.mo $DESTDIR/usr/share/locale/zh_CN/LC_MESSAGES/multivnc_client.mo
	mkdir -p $DESTDIR/usr/share/locale/vi/LC_MESSAGES/
	cp -f src_client/po/vi.mo $DESTDIR/usr/share/locale/vi/LC_MESSAGES/multivnc_client.mo
	mkdir -p $DESTDIR/usr/share/locale/ro/LC_MESSAGES/
	cp -f src_client/po/ro.mo $DESTDIR/usr/share/locale/ro/LC_MESSAGES/multivnc_client.mo
}

install_server() {
	mkdir -p $DESTDIR/usr/bin/
	cp -f multivnc_server $DESTDIR/usr/bin/.

	mkdir -p $DESTDIR/etc/multivnc/
	cp -f server.conf $DESTDIR/etc/multivnc/.
	chmod 666 $DESTDIR/etc/multivnc/server.conf

	mkdir -p $DESTDIR/usr/share/locale/ja/LC_MESSAGES/
	cp -f src_server/po/ja.mo $DESTDIR/usr/share/locale/ja/LC_MESSAGES/multivnc_server.mo
	mkdir -p $DESTDIR/usr/share/locale/zh_CN/LC_MESSAGES/
	cp -f src_server/po/zh_CN.mo $DESTDIR/usr/share/locale/zh_CN/LC_MESSAGES/multivnc_server.mo
	mkdir -p $DESTDIR/usr/share/locale/vi/LC_MESSAGES/
	cp -f src_server/po/vi.mo $DESTDIR/usr/share/locale/vi/LC_MESSAGES/multivnc_server.mo
	mkdir -p $DESTDIR/usr/share/locale/ro/LC_MESSAGES/
	cp -f src_server/po/ro.mo $DESTDIR/usr/share/locale/ro/LC_MESSAGES/multivnc_server.mo
}

case $TARGET in
	client)
		install_client
		;;
	server)
		install_server
		;;
	all)
		install_client
		install_server
		;;
	*)
		install_client
		install_server
		;;
esac
echo "MultiVNC Install COMPLETE!"

