/*
 *  Copyright (C) 2005 Ltd. Alphasystems  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

/*
 * pixel.c - handle pixel data.
 *
 * This file shouldn't be compiled directly.  It is included multiple times by
 * multivnc_client.c, each time with a different definition of the macro BPP and
 * BPPC. 
 */

#define changePixelFormatBPPToBPPC CONCAT2E(CONCAT2E(changePixelFormat,BPP),CONCAT2E(To,BPPC))
#define CARDBPP CONCAT2E(CARD,BPP)
#define CARDBPPC CONCAT2E(CARD,BPPC)

int
changePixelFormatBPPToBPPC(char *src_buf, int src_size, char *new_buf)
{
  int red_shift, green_shift, blue_shift;
  int src_size_count;
  int new_buf_size;
  CARD8 *src_buf_ptr;
  CARD8 *new_buf_ptr;
  CARDBPP src_pixel;
  CARDBPPC new_pixel;
  CARD8 src_red_data, src_green_data, src_blue_data;
  CARD8 new_red_data, new_green_data, new_blue_data;

  if (src_buf == NULL) {
    fprintf(stderr, "changePixelFormat : buffer is NULL.\n");
    return -1;
  }
  if (src_size <= 0) {
    fprintf(stderr, "changePixelFormat : size <= 0.\n");
    return 0;
  }
  red_shift = adjustColorBitShift(client_CB.serverFormat.redMax, myFormat.redMax);
  green_shift = adjustColorBitShift(client_CB.serverFormat.greenMax, myFormat.greenMax);
  blue_shift = adjustColorBitShift(client_CB.serverFormat.blueMax, myFormat.blueMax);

  src_buf_ptr = (CARD8 *)src_buf;
  new_buf_ptr = (CARD8 *)new_buf;
  src_size_count = src_size;
  new_buf_size = 0;
  while (src_size_count >= sizeof(CARDBPP)) {
    /* cpy 1 pixel */
    memcpy((char *)&src_pixel, src_buf_ptr, sizeof(CARDBPP));

    /* Pixel -> RGB */
    src_red_data = (CARD8)(src_pixel >> client_CB.serverFormat.redShift);
    src_green_data = (CARD8)((src_pixel & (CARDBPP)(client_CB.serverFormat.greenMax << client_CB.serverFormat.greenShift)) \
		      >> client_CB.serverFormat.greenShift);
    src_blue_data = (CARD8)(src_pixel & (CARDBPP)client_CB.serverFormat.blueMax);

    /* Shift RGB */
#if (BPP > BPPC)
    new_red_data = src_red_data >> red_shift;
    new_green_data = src_green_data >> green_shift;
    new_blue_data = src_blue_data >> blue_shift;
#else
    new_red_data = src_red_data << red_shift;
    new_green_data = src_green_data << green_shift;
    new_blue_data = src_blue_data << blue_shift;
#endif

    /* RGB -> Pixel */
    new_pixel = ((CARDBPPC)new_red_data << myFormat.redShift) | ((CARDBPPC)new_green_data << myFormat.greenShift) | \
		 (CARDBPPC)new_blue_data;

    /* To new_buf */
    memcpy(new_buf_ptr, &new_pixel, sizeof(CARDBPPC));

    src_buf_ptr += sizeof(CARDBPP);
    new_buf_ptr += sizeof(CARDBPPC);
    src_size_count -= sizeof(CARDBPP);
    new_buf_size += sizeof(CARDBPPC);
  }

  return new_buf_size;
}

