#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <pthread.h>
#include <unistd.h>
#include <signal.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "vncviewer_s.h"
#include "image_processing.h"


pthread_mutex_t s_mutex;
pthread_t s_thread;

/**********************************/
/* For server functions           */
/**********************************/

/*
 * サーバ画像処理用スレッド関数
 */
void *image_proc_server (void *arg)
{
    int h,k,n;        //ヒストグラム要素、クライアント、バッファループ用
    struct server_cb *server_CB = arg;
    struct client_grp **client_grp;

    int global_hist_h[MAX_HIST];                //大域ヒストグラム
    int client_hist_h[MAXCLIENT][MAX_HIST];    //クライアントヒストグラム
    int flag_exist[MAXCLIENT];                 //クライアントの存在
    int flag_irregular[MAXCLIENT];             //イレギュラー状態判別用
    int kajou_hist_h[MAXCLIENT];               //過乗率
    int kesson_hist_h[MAXCLIENT];              //欠損率
    int matching_hist_h[MAXCLIENT];            //一致率

    /* block all signal in this thread */
    sigset_t set;
    sigfillset(&set);
    pthread_sigmask(SIG_SETMASK, &set, NULL);

    while (1)
    {
        int num_client = 0;
        int buf_hist[NORMALIZE_HIST];
        int sum_buf_hist = 0;
        int sum_global_hist_h = 0;

        //初期化
        memset(global_hist_h,0,sizeof(global_hist_h));
        memset(client_hist_h,0,sizeof(client_hist_h));
        memset(flag_exist,0,sizeof(flag_exist));
        memset(flag_irregular,0,sizeof(flag_irregular));
        memset(kajou_hist_h,0,sizeof(kajou_hist_h));
        memset(kesson_hist_h,0,sizeof(kesson_hist_h));
        memset(matching_hist_h,0,sizeof(matching_hist_h));

        //クライアント情報取得
        pthread_mutex_lock(&s_mutex);
        client_grp = server_CB->client_grp;
        num_client = 0;
        for (k = 0;k < MAXCLIENT;k++)
        {
            if (client_grp[k] != NULL &&
                client_grp[k]->client_status != NOSTAT )
            {
                memcpy(client_hist_h[k],client_grp[k]->histogram_h,
                       sizeof(int)*MAX_HIST);
                flag_exist[k] = 1;
                num_client++;
            }
        }
        pthread_mutex_unlock(&s_mutex);
        dbg("sum_c:%d",num_client);

        if (num_client < 3)
        {
            //三人以上居なければイレギュラー判定は行わない
            dbg ("not checked.");
        }
        else
        {
            //大域ヒストグラム生成
            dbg ("checking...");
            for (h = 0;h < MAX_HIST;h++)
            {
                memset(buf_hist,0,sizeof(buf_hist));
                sum_buf_hist = 0;
                for (k = 0;k < MAXCLIENT;k++)
                {
                    if(flag_exist[k] == 0) continue;
                    buf_hist[client_hist_h[k][h]]++;
                }
                for (n = 0;n < NORMALIZE_HIST;n++)
                {
                    sum_buf_hist += buf_hist[n];
                    if(sum_buf_hist > num_client / 2) break;
                }
                global_hist_h[h] = n;
            }
//for (h = 1;h < MAX_HIST;h++) printf("%d,",global_hist_h[h]);
//printf("\n");

            //イレギュラー判定
            sum_global_hist_h = 0;
            for (h = 2;h < MAX_HIST;h++) sum_global_hist_h += global_hist_h[h];
            if (sum_global_hist_h < 10)
            {
                dbg ("chaos(global_hist not enough)");
                for (k = 0;k < MAXCLIENT;k++) flag_irregular[k] = CHAOS;
            }
            else
            {
                for (k = 0;k < MAXCLIENT;k++)
                {
                    if(flag_exist[k] == 0) continue;
                    for (h = 1;h < MAX_HIST;h++)
                    {
                        int freq = client_hist_h[k][h];
                        if ( freq >= global_hist_h[h] )
                        {
                            kajou_hist_h[k] += (freq - global_hist_h[h]);
                        }else{
                            kesson_hist_h[k] += (global_hist_h[h] - freq);
                        }
                    }
                    matching_hist_h[k]
                         = (int)((1-(kajou_hist_h[k]+kesson_hist_h[k])
                                 / (double)sum_global_hist_h)*100);
                    if (matching_hist_h[k] <= 0) flag_irregular[k] = IRREGULAR;
                    else                         flag_irregular[k] = NORMAL;
                    printf("<%2d> kajou:%4d kesson:%4d matching:%4d\n",
                        k,kajou_hist_h[k],kesson_hist_h[k],matching_hist_h[k]);
                }
                int sum_regular = 0;
                for (k = 0;k < MAXCLIENT;k++)
                    if (flag_exist[k]     == 1      &&
                        flag_irregular[k] != IRREGULAR) sum_regular++;
                dbg("sum_r:%d",sum_regular);
                if (sum_regular <= num_client / 2)
                {
                    dbg ("chaos(sum_r not enough)");
                    for (k = 0;k < MAXCLIENT;k++) flag_irregular[k] = CHAOS;
                }
            }
        }

        //情報送信
        pthread_mutex_lock(&s_mutex);
        for (k = 0;k < MAXCLIENT;k++)
        {
            if (client_grp[k] != NULL &&
                client_grp[k]->client_status != NOSTAT )
            {
                dbg("(%d)flag_irregular=%d",k,flag_irregular[k]);
		if (client_grp[k]->client_status != flag_irregular[k]) {
                  client_grp[k]->client_status = flag_irregular[k];
		  exprocSendStatusChangedMsg(k, makeClientStatus(k));
		}
            }
        }
        pthread_mutex_unlock(&s_mutex);

        fprintf(stderr, "image_proc_server\n");
        dbg("Operate state decision time interval:%d\n", server_CB->opestate_interval);
	sleep (server_CB->opestate_interval);
    }//end of while
}

/*
 * ヒストグラム受信関数
 */
void GetHistogram (int clientNum, char *buf, int socket)
{
    int f_status;
    HistogramAdv *hadv = (HistogramAdv *)buf;
    int rep;

    /* ヘッダを除くパケットの残りを取得 */
    rep = 0;
    do {
	if ((rep += recv (socket, buf + 2 + rep, sizeof(HistogramAdv) - 2 - rep, 0)) <= 0) {
		// error
	}
    } while (rep != sizeof(HistogramAdv)-2);
    //dbg("######## rep=%d == %d",rep, sizeof(HistogramAdv)-2);

    f_status = hadv->status;

    //TODO : flag処理
    pthread_mutex_lock(&s_mutex);
    if (f_status == FREEZE) {
	dbg("                                                    FREEZE");
	if (server_CB.client_grp[clientNum]->client_status != FREEZE) {
	  server_CB.client_grp[clientNum]->client_status = FREEZE;
	  exprocSendStatusChangedMsg(clientNum, makeClientStatus(clientNum));
	}
    }

    if (server_CB.client_grp[clientNum]->client_status == NOSTAT) {
	dbg("                                                    FIRST CONTACT");
	server_CB.client_grp[clientNum]->client_status = f_status;
	if ((f_status != NOSTAT) && (f_status != NORMAL)) {
	  exprocSendStatusChangedMsg(clientNum, makeClientStatus(clientNum));
	}
    }
    dbg("now status =%d", server_CB.client_grp[clientNum]->client_status);

    memcpy(server_CB.client_grp[clientNum]->histogram_h, hadv->histogram_h, MAX_HIST);
    memcpy(server_CB.client_grp[clientNum]->histogram_s, hadv->histogram_s, MAX_HIST);
    memcpy(server_CB.client_grp[clientNum]->histogram_v, hadv->histogram_v, MAX_HIST);

    set_client_color (server_CB.client_grp[clientNum]->draw_page, server_CB.client_grp[clientNum]->draw_area);
    pthread_mutex_unlock(&s_mutex);

    dbg ("UPDATE HISTOGRAM : %s (%d)",
	    server_CB.client_grp[clientNum]->client_ID,
	    server_CB.client_grp[clientNum]->client_status
	);
}

