#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <arpa/inet.h>
#include "vncviewer.h"

int get_ifaddr(char *interface, char *addr)
{
	int sock;
	struct ifreq ifr;
	char *ipaddr;

	if (!interface || !addr) {
		return -1;
	}
	
	// $man netdevice
	sock = socket(AF_INET, SOCK_DGRAM, 0);
	memset(&ifr, 0, sizeof(ifr));
	ifr.ifr_addr.sa_family = AF_INET;
	strncpy(ifr.ifr_name, interface, IFNAMSIZ - 1);
	if (ioctl(sock, SIOCGIFADDR, &ifr)) {
		close(sock);
		printf("get IP Address failed\n");
		return -1;
	}
	if (ioctl(sock, SIOCGIFFLAGS, &ifr)) {
		close(sock);
		printf("get IP Address failed\n");
		return -1;
	}
	close(sock);

	if (((ifr.ifr_flags & IFF_UP) == 0) || ((ifr.ifr_flags & IFF_RUNNING) == 0)) {
		printf("NIC is not running\n");
		return -1;
	}

	ipaddr = (char *)inet_ntoa(((struct sockaddr_in *)&(ifr.ifr_addr))->sin_addr);
	strcpy(addr, ipaddr);

	return 0;
}

int get_macaddr(char *interface, unsigned char *addr)
{
	int sock;
	struct ifreq ifr;
	int i;

	if (!interface || !addr) {
		return -1;
	}
	
	// $man netdevice
	sock = socket(AF_INET, SOCK_DGRAM, 0);
	memset(&ifr, 0, sizeof(ifr));
	ifr.ifr_addr.sa_family = AF_INET;
	strncpy(ifr.ifr_name, interface, IFNAMSIZ - 1);
	if (ioctl(sock, SIOCGIFHWADDR, &ifr)) {
		close(sock);
		return -1;
	}
	close(sock);

	for (i = 0; i < MACADDR_SIZE; i++) {
		addr[i] = ifr.ifr_hwaddr.sa_data[i];
	}
	
	return 0;
}

int find_macaddr(int sock, unsigned char *addr) {
	struct sockaddr_in src_addr;
	socklen_t len;
	struct ifconf ifc;
	struct ifreq ifr[8];
	int i;
	
	memset(&src_addr, 0, sizeof(src_addr));
	len = sizeof(src_addr);
	if (getsockname(sock, (struct sockaddr *)&src_addr, &len)) {
		return -1;
	}

	memset(&ifc, 0, sizeof(ifc));
	memset(&ifr, 0, sizeof(ifr));
	ifc.ifc_len = sizeof(ifr);
	ifc.ifc_req = ifr;
	if (ioctl(sock, SIOCGIFCONF, &ifc)) {
		return -1;
	}

	for (i = 0; i < ifc.ifc_len / sizeof(struct ifreq); i++) {
		if (*(in_addr_t *)&(src_addr.sin_addr) == *(in_addr_t *)&((struct sockaddr_in *)&(ifc.ifc_req[i].ifr_addr))->sin_addr) {
			return get_macaddr(ifc.ifc_req[i].ifr_name, addr);
		}
	}
	
	return -1;
}

void show_gtkwindow(GtkWidget *widget)
{
	XEvent event;
	Display *disp;
	Window win;

	memset(&event, 0, sizeof(event));
	event.xclient.type = ClientMessage;
	event.xclient.send_event = True;
	event.xclient.window = GDK_WINDOW_XWINDOW(widget->window);
	event.xclient.message_type = gdk_x11_get_xatom_by_name("_NET_ACTIVE_WINDOW");
	event.xclient.format = 32;
	event.xclient.data.l[0] = 2;
	disp = gdk_x11_drawable_get_xdisplay(widget->window);
	win = gdk_x11_get_default_root_xwindow();
	XSendEvent(disp, win, False, SubstructureNotifyMask | SubstructureRedirectMask, &event);
	XFlush(disp);
}

int move_gtkwindow(GtkWidget *widget, int monitor)
{
	int x;
	int y;
	int mon;
	GdkRectangle rectFrom;
	GdkRectangle rectTo;

	if (monitor < 0) {
		return 0;
	}

	gtk_window_get_position(GTK_WINDOW(widget), &x, &y);
	mon = gdk_screen_get_monitor_at_point(gtk_widget_get_screen(widget), x, y);
	if (mon == monitor) {
		return 0;
	}
	gdk_screen_get_monitor_geometry(gtk_widget_get_screen(widget), mon, &rectFrom);
	gdk_screen_get_monitor_geometry(gtk_widget_get_screen(widget), monitor, &rectTo);
	x = rectTo.x - rectFrom.x + x;
	y = rectTo.y - rectFrom.y + y;
	gtk_window_move(GTK_WINDOW(widget), x, y);
	return 1;
}

