/*
 * ata_dma.h
 *
 * Copyright 2007, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef ata_dma_h
#define ata_dma_h


#include <sys/uio.h>
#include <dev/pci/pci.h>
#include <kern/device.h>


#ifndef ASM_FILE


// DMA⡼
enum {
	NO_DMAMODE = 0,
	WDMA0,
	WDMA1,
	WDMA2,
	UDMA0,
	UDMA1,
	UDMA2,
	UDMA3,
	UDMA4,
	UDMA5,
};

extern void readDmaIovec(const int, const int, struct iovec *, WAIT_INTR *);
extern void writeDmaIovec(const int, const int, struct iovec *, WAIT_INTR *);
extern int initDma(const int, const int, const int, int *);
extern int initDmaIntel(const int, const int, const PCI_INFO, const int, int *);

#endif


#endif
