/*
 * pci.h (C) 2002 Minoru Murashima
 *
 * Copyright 2002, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 * PCI
 */


#ifndef pci_h
#define pci_h


#ifndef ASM_FILE


#include <sys/types.h>


enum{
	/* Configuration registers. */
	PCI_CONF_VENDER=	0x0,
	PCI_CONF_DEVICE=	0x2,
	PCI_CONF_COMMAND=	0x4,
	PCI_CONF_STATUS=	0x6,
	PCI_CONF_REVIVION=	0x8,
	PCI_CONF_CLASS=		0x9,
	PCI_CONF_CACHE=		0xc,
	PCI_CONF_LATENCY=	0xd,
	PCI_CONF_HEDTYPE=	0xe,
	PCI_CONF_BIST=		0xf,
	PCI_CONF_BMAR=      0x30,
	PCI_CONF_INTRLIN=	0x3c,
	PCI_CONF_INTRPIN=	0x3d,
	PCI_CONF_MNGNT=     0x3e,
	PCI_CONF_MXLAT=     0x3f,

	/* Command register bit. */
	PCI_COMMAND_IOACS=		1<<0,
	PCI_COMMAND_MEMACS=		1<<1,
	PCI_COMMAND_BSMST=		1<<2,		/* Bus Master enable */
	PCI_COMMAND_SPCYC=		1<<3,
	PCI_COMMAND_MEMWINV=	1<<4,
	PCI_COMMAND_VGASNOOP=	1<<5,
	PCI_COMMAND_PRTYERR=	1<<6,
	PCI_COMMAND_ADDRSTP=	1<<7,
	PCI_COMMAND_SYSERR=		1<<8,
	PCI_COMMAND_FSTBCK=		1<<9,

	/* Class coad. */
	PCI_CLASS_ISA_BRIDGE=0x060100,		/* ISA bridge. */
	PCI_CLASS_IDE_BSMST= 0x010180,		/* IDE bus master. */
	PCI_CLASS_ETHER=	 0x020000,		/* Ethernet. */
	PCI_CLASS_DISP_CTRL= 0x030000,		/* Display controler. */
};


typedef struct{
	uint vidDid;		/* VenderID(0-15bit) + deviceID(16-31bit) */
	int bus;
	int dev;
	int func;
}PCI_INFO;
/*
// 饹ɲäС
typedef struct{
	uint vidDid;		// VenderID(0-15bit) + deviceID(16-31bit)
	int bus;
	int class;
	int dev;
	int func;
}PCI_INFO;
*/

extern uint read_pci_config(const PCI_INFO, const int);
extern void writedw_pci_config(const PCI_INFO, const int, const uint);
extern void writew_pci_config(const PCI_INFO, const int, const ushort);
extern void writeb_pci_config(const PCI_INFO, const int, const uchar);
extern int search_pci_class(const int, const PCI_INFO, PCI_INFO *);
extern uint getPciMemAddress(int);
extern int getPciIrq(const PCI_INFO);
extern int initPci();


#endif


#endif
