/*
 * Cpu.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <i386/Cpu.h>

#include <kern/debug.h>


//#define DEBUG_I386_CPU 1
#ifdef DEBUG_I386_CPU
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

extern void CpuIntelConstructor(Cpu *);
extern void CpuAmdConstructor(Cpu *);

//===================================== PRIVATE ====================================================

/*
 * cpuid̿ᥳޥ
 */
enum {
	CMD_VENDOR_ID	= 0,	// ٥IDθ
};

/*
 * CPU signature struct.
 */
typedef union {
	struct cpuSign {
		uint model		: 12;
		uint type		: 2;
		uint reserve1	: 2;
		uint extModel	: 4;
		uint extfamily	: 8;
		uint reserve2	: 4;
	} cpuSign;
	uint cpuid;
} ST_CPU_SIGN;

/*
 * ٥ID
 */
static const char *venderIntel	= "GenuineIntel";	// Intel
static const char *venderAmd	= "AuthenticAMD";	// AMD

//===================================== PUBLIC =====================================================

/*
 * CPUID
 */
void getCpuId(
	const int i_cmd,	// cpuid̿ᥳޥ
	CPUID_OUT *m_cpuid)
{
	asm volatile(
		"cpuid"
		:"=a"(m_cpuid->eax),
		 "=b"(m_cpuid->ebx),
		 "=d"(m_cpuid->edx),
		 "=c"(m_cpuid->ecx)
		:"a"(i_cmd)
	);
}

/*
 * Cpu󥹥󥹤
 * return : error number
 */
int CpuConstructor(
	Cpu *m_cpu)
{
	CPUID_OUT cpuid;
	union {
		char id[sizeof(int) * 3];
		struct reg {
			uint ebx;
			uint edx;
			uint ecx;
		} reg;
	} vendorId;

	// ٥IDǧ
	getCpuId(CMD_VENDOR_ID, &cpuid);
	vendorId.reg.ebx = cpuid.ebx;
	vendorId.reg.edx = cpuid.edx;
	vendorId.reg.ecx = cpuid.ecx;
	if (memcmp(vendorId.id, venderIntel, sizeof(int) * 3) == 0) {
		CpuIntelConstructor(m_cpu);
	}
	else if (memcmp(vendorId.id, venderAmd, sizeof(int) * 3) == 0) {
		CpuAmdConstructor(m_cpu);
	}
	else {
		return -ENODEV;
	}
	
	return NOERR;
}

/*
 * ƥॳ
 * ®ƥॳ򥵥ݡȤƤ뤫
 * return : 0 or -1
 */
int sysIsSupportSysenter()
{
	Cpu cpu;
	int error;
	
	error = CpuConstructor(&cpu);
	if (error != NOERR) {
		return error;
	}
	
	if (cpu.isSupportSysenter(&cpu) == YES) {
		return 0;
	}
	else {
		return -1;
	}
}
