/*
 * Cpu.h
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef i386_Cpu_h
#define i386_Cpu_h


#include <sys/types.h>


#ifndef ASM_FILE


typedef struct Cpu {
	int (*isSupportCpu)(const struct Cpu *);
	int (*isSupportSysenter)(const struct Cpu *);
	void (*setLocalApicBaseAddr)(const struct Cpu *, const uint);
	void (*setSysenter)(const struct Cpu *);
} Cpu;

/*
 * cpuid̿
 */
typedef struct {
	uint eax;
	uint ebx;
	uint edx;
	uint ecx;
} CPUID_OUT;

extern int CpuConstructor(Cpu *);
extern int getCpu();
extern uint64 readMsr(const uint);
extern void writeMsr(const uint, const uint64);
extern int sysIsSupportSysenter();
extern uint32_t readCr4();
extern void writeCr4(uint32_t);


#endif


#endif
