/*
 * CpuAmd.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <i386/Cpu.h>

#include <kern/debug.h>


//#define DEBUG_I386_CPU_AMD 1
#ifdef DEBUG_I386_CPU_AMD
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

extern void getCpuId(const int, CPUID_OUT *);
extern void CpuIntelConstructor(Cpu *);

//===================================== PRIVATE ====================================================

/*
 * cpuid̿ᥳޥ
 */
enum {
	CMD_CPU_ID		= 1,	// CPUIDθ
};

/*
 * cpuid̿
 */
typedef struct {
	uint eax;
	uint ebx;
	uint edx;
	uint ecx;
} CPUID;

/*
 * CPU function struct.
 */
typedef union {
	struct cpuFunc {
		uint fpu		: 1;	// åפư˥å
		uint vme		: 1;	// ۥ⡼ɳĥǽ
		uint de			: 1;	// ǥХåĥǽ
		uint pse		: 1;	// ڡĥ
		uint tsc		: 1;	// ॹץ
		uint msr		: 1;	// ǥͭ쥸
		uint pae		: 1;	// ʪɥ쥹ĥ
		uint mce		: 1;	// ޥå㳰
		uint cx8		: 1;	// CMPXCHG8 ̿Υݡ
		uint apic		: 1;	// åAPIC ϡɥΥݡ
		uint reserve1	: 1;	// ͽ
		uint sep		: 1;	// ®ƥॳ
		uint mtrr		: 1;	// ꥿ϰϥ쥸
		uint pge		: 1;	// ڡХ롦֥͡
		uint mca		: 1;	// ޥ󡦥åƥ
		uint cmov		: 1;	// դư̿Υݡ
		uint reserve2	: 1;	// ͽ
		uint pse36		: 1;	// 36 ӥåȡڡĥ
		uint psn		: 1;	// ץåꥢ롦ʥФ¸ߤ֥͡ˤʤäƤ
		uint clfsh		: 1;	// CLFLUSH ̿Υݡ
		uint reserve3	: 3;	// ͽ
		uint mmx		: 1;	// ƥ롦ƥMMX ƥΥΥݡ
		uint fxsr		: 1;	// ®ư/ꥹȥ
		uint sse		: 1;	// ȥ꡼ߥSIMDĥ̿Υݡ
		uint sse2		: 1;	// ȥ꡼ߥSIMDĥ̿2
		uint reserve4	: 1;	// ͽ
		uint htt		: 1;	// ϥѡåǥ󥰡ƥΥ
		uint reserve5	: 3;	// ͽ
	} cpuFunc;
	uint cpuid;
} ST_CPU_FUNC;

/*
 * ®ƥॳ򥵥ݡȤƤ뤫
 * return : YES or NO
 */
STATIC int isSupportSysenter(
	const Cpu *i_cpu)
{
	CPUID_OUT cpuid;
	ST_CPU_FUNC cpuFunc;

	getCpuId(CMD_CPU_ID, &cpuid);
	cpuFunc.cpuid = cpuid.edx;
	if (cpuFunc.cpuFunc.sep == 1) {
		return YES;
	}
	else {
		return NO;
	}
}

//===================================== PUBLIC =====================================================

/*
 * 󥹥ȥ饯
 */
void CpuAmdConstructor(
	Cpu *m_cpu)
{
	CpuIntelConstructor(m_cpu);
	m_cpu->isSupportSysenter = isSupportSysenter;
}
