/*
 * CpuIntel.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <i386/Cpu.h>
#include <i386/UserHandler.h>

#include <kern/debug.h>


//#define DEBUG_I386_CPU_INTEL 1
#ifdef DEBUG_I386_CPU_INTEL
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

extern void getCpuId(const int, CPUID_OUT *);

//===================================== Х륤ݡ =======================================

//===================================== PRIVATE ====================================================

/*
 * cpuid̿ᥳޥ
 */
enum {
	CMD_CPU_ID		= 1,	// CPUIDθ
};

/*
 * CPU signature.
 */
enum CPU_MODEL {
	I386		= 0x300,
	I486		= 0x400,
	PENTIUM		= 0x500,
	PENTIUM_PRO	= 0x610,
	PENTIUM2	= 0x630,
};

/*
 * ǥͭ쥸
 */
enum {
	// MSR쥸
	MSR_APIC_BASE		= 0x1b,
	MSR_SYSENTER_CS		= 0x174,
	MSR_SYSENTER_ESP	= 0x175,
	MSR_SYSENTER_EIP	= 0x176,
};

/*
 * CPU signature struct.
 */
typedef union {
	struct cpuSign {
		uint model		: 12;
		uint type		: 2;
		uint reserve1	: 2;
		uint extModel	: 4;
		uint extfamily	: 8;
		uint reserve2	: 4;
	} cpuSign;
	uint cpuid;
} ST_CPU_SIGN;

/*
 * CPU function struct.
 */
typedef union {
	struct cpuFunc {
		uint fpu		: 1;	// åפư˥å
		uint vme		: 1;	// ۥ⡼ɳĥǽ
		uint de			: 1;	// ǥХåĥǽ
		uint pse		: 1;	// ڡĥ
		uint tsc		: 1;	// ॹץ
		uint msr		: 1;	// ǥͭ쥸
		uint pae		: 1;	// ʪɥ쥹ĥ
		uint mce		: 1;	// ޥå㳰
		uint cx8		: 1;	// CMPXCHG8 ̿Υݡ
		uint apic		: 1;	// åAPIC ϡɥΥݡ
		uint reserve1	: 1;	// ͽ
		uint sep		: 1;	// ®ƥॳ
		uint mtrr		: 1;	// ꥿ϰϥ쥸
		uint pge		: 1;	// ڡХ롦֥͡
		uint mca		: 1;	// ޥ󡦥åƥ
		uint cmov		: 1;	// դư̿Υݡ
		uint pat		: 1;	// ڡ°ơ֥
		uint pse36		: 1;	// 36 ӥåȡڡĥ
		uint psn		: 1;	// ץåꥢ롦ʥФ¸ߤ֥͡ˤʤäƤ
		uint clfsh		: 1;	// CLFLUSH ̿Υݡ
		uint reserve2	: 1;	// ͽ
		uint ds			: 1;	// ǥХåȥ
		uint acpi		: 1;	// ٥˥ȥեȥ楯åǽΥݡ
		uint mmx		: 1;	// ƥ롦ƥMMX ƥΥΥݡ
		uint fxsr		: 1;	// ®ư/ꥹȥ
		uint sse		: 1;	// ȥ꡼ߥSIMDĥ̿Υݡ
		uint sse2		: 1;	// ȥ꡼ߥSIMDĥ̿2
		uint ss			: 1;	// ʥ̡
		uint htt		: 1;	// ϥѡåǥ󥰡ƥΥ
		uint tm			: 1;	// ٥˥Υݡ
		uint reserve3	: 1;	// ͽ
		uint pbe		: 1;	// ڥǥ󥰡֥졼֥͡
	} cpuFunc;
	uint cpuid;
} ST_CPU_FUNC;

//--------------------------------------------------------------------------------------------------
// ᥽å
//--------------------------------------------------------------------------------------------------

/*
 * OSǥݡȤƤCPU
 * return : YES or NO
 */
STATIC int isSupportCpu(
	const Cpu *i_cpu)
{
	CPUID_OUT cpuid;
	ST_CPU_FUNC cpuFunc;
	
	// ڡĥ򥵥ݡȤƤ뤫
	getCpuId(CMD_CPU_ID, &cpuid);
	cpuFunc.cpuid = cpuid.edx;
	if (cpuFunc.cpuFunc.pse == 1) {
		return YES;
	}
	else {
		return NO;
	}
}

/*
 * APIC١ɥ쥹
 */
STATIC void setLocalApicBaseAddr(
	const Cpu *i_cpu,
	const uint i_baseAddr)
{
	enum {
		APIC_ENABLE = 0x800
	};
	CPUID_OUT cpuid;
	ST_CPU_FUNC cpuFunc;

	getCpuId(CMD_CPU_ID, &cpuid);
	cpuFunc.cpuid = cpuid.edx;
	if (cpuFunc.cpuFunc.apic == 1) {
		writeMsr(MSR_APIC_BASE, (uint64) (i_baseAddr | APIC_ENABLE));
	}
}

/*
 * ®ƥॳ򥵥ݡȤƤ뤫
 * return : YES or NO
 */
STATIC int isSupportSysenter(
	const Cpu *i_cpu)
{
	CPUID_OUT cpuid;
	ST_CPU_SIGN cpuSign;
	ST_CPU_FUNC cpuFunc;

	getCpuId(CMD_CPU_ID, &cpuid);
	cpuSign.cpuid = cpuid.eax;
	cpuFunc.cpuid = cpuid.edx;
	if ((cpuFunc.cpuFunc.sep == 1) && (PENTIUM2 <= cpuSign.cpuSign.model)) {
			return YES;
	}
	else {
		return NO;
	}
}

/*
 * ãУդι®ƥॳν
 */
STATIC void setSysenter(
	const Cpu *i_cpu)
{
	// SYSENTER_CS_MSR
	writeMsr(MSR_SYSENTER_CS, KERNEL_CODE_DES);

	// SYSENTER_ESP_MSR
	writeMsr(MSR_SYSENTER_ESP, KERNEL_ESP_BEG);

	// SYSENTER_EIP_MSR
	writeMsr(MSR_SYSENTER_EIP, (uint64) returnUserMethod);
}

//===================================== PUBLIC =====================================================

void CpuIntelConstructor(
	Cpu *m_cpu)
{
	m_cpu->isSupportCpu = isSupportCpu;
	m_cpu->isSupportSysenter = isSupportSysenter;
	m_cpu->setLocalApicBaseAddr = setLocalApicBaseAddr;
	m_cpu->setSysenter = setSysenter;
}
