/*
 * DevInterrupt.c
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 *
 *Գס
 *
 *
 *
 *ԸƤ
 */


#include <sys/config.h>
#include <sys/types.h>
#include <sys/param.h>
#include <lib/lib.h>
#include <kern/Thread.h>
#include <kern/Wait.h>
#include <kern/vm.h>
#include <module/interrupt.h>
#include <i386/interrupt.h>
#include <i386/Entry.h>
#include <i386/UserHandler.h>

#include <kern/debug.h>


//#define DEBUG_DEVINTERRUPT 1
#ifdef DEBUG_DEVINTERRUPT
	#define STATIC
	#define INLINE
#else
	#define STATIC	static
	#define INLINE	inline
#endif


//=====================================  ===================================================

//===================================== Х륤ݡ =======================================

extern void sendUserIntrMethod(VmTaskObj*, void*, uint, uint *setModule(VmTaskObj*), uint *resetModule());

//===================================== PRIVATE ====================================================

/*
 * return : task switch NO
 */
STATIC int defaultIntrHandler(int irq)
{
	printk("interrupt : %d\n", irq);
	return NO;
}

//===================================== PUBLIC =====================================================

/*
 * ͥߥϥɥƤӽФ
 *Գ
 *ԸƤեƥࡦ桼֤η¬ˡ
 * return : task switch YES or NO
 */
int doKernIntrHandler(
//	const int i_irq)		// IRQֹ
//******************************************
	const int i_irq,
	TaskContext context)
//******************************************
{
	int isTaskSwitch;
//*********************************************************
//testDevInterrupt(i_irq, 1, context.eip);
//*********************************************************

	// ߻
	calcTaskUserTime();
	setTaskCurrentTime();

	// ϥɥ顼ƤӽФ
	isTaskSwitch = irq_entry[i_irq](i_irq);

	// ߻
	calcTaskSysTime();
	setTaskCurrentTime();

	return isTaskSwitch;
}

/*
 * 桼ߥϥɥƤӽФ
 *Գ
 *ԸƤֵͤɤꤹ뤫
 * return : task switch YES or NO
 */
int doUserIntrHandler(
	const int i_irq)		// IRQֹ
{
	ThreadObj *currentTask = getCurrentTask();
	ThreadObj *driverTask = IntrDscGetTask(i_irq);
	uint userEsp;

	// ʥϥɥ¹
	TaskSignalStopHandler(TaskGetTaskSignal(currentTask));

	// 桼⡼ɤɣľܤǤ褦ꤹ
	setUserModeIo();
	
	// ϥɥѥ᡼ꤹ
	userEsp = vmSetModuleParam(getVmTask(driverTask), IntrDscGetReturnMethod(i_irq), (uint) IntrDscGetArg(i_irq), 0, 0, 0, 0, 0);

	// 桼ߥ᥽åɤƤӽФ
	sendUserIntrMethod(
		getVmTask(driverTask),
		IntrDscGetHandler(i_irq),
		userEsp,
		vmSetModule, 
		vmResetModule);

	// ʥϥɥ¹ԺƳ
	TaskSignalRestartHandler(TaskGetTaskSignal(currentTask));

	return 1;
}

/*
 * Release hard interrupt mask
 * parameters : IRQ number
 */
void (*release_irq_mask)(uchar);

/*
 * Set hard interrupt mask
 * parameters : IRQ number
 */
void (*set_irq_mask)(uchar);

/*
 * ϡɳѣţϣɴؿ
 * parameters : IRQ number
 */
void (*irq_eoi)(uchar);

/*
 * ͥߥϥɥơ֥
 * returns : task switch on 1,off 0
 */
int (*irq_entry[IRQ_ENTRY])(int) = {
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler,
	defaultIntrHandler
};

/*
 * 󥹥ȥ饯
 */
void DevInterruptConstructor()
{
}

/*
 * ǥȥ饯
 */
void DevInterruptDestructor()
{
}

/*
 * ߥϥɥ饿˰ܹ
 *ճ߶ػߤǸƤӽФ
 *Գ
 * return : Page directory
 */
void *changeIntrTask()
{
	// ǥХɥ饤С򥹥塼ɲä
	wakeTaskSoon(getWaitTask(getCallTask(getCurrentTask())), TASK_WAIT);

	return switchTask();
}

/*
 * ߥϥɥ饿᤹
 *ճ߶ػߤǸƤӽФ
 *Գ
 */
void *endIntrTask()
{
	irq_eoi(getIrqTask(getCurrentTask()));

	// ǥХɥ饤С򥹥꡼פ
	sleepTask(TASK_WAIT);
	
	// äƤʤ
	return NULL;
}

/*
 * 桼ߥϥɥ򥻥åȤ
 */
void setUserIntrHandler(
	const int i_irq)		// IRQ
{
	ASSERT((0 <= i_irq) & (i_irq <= IRQ_ENTRY));

	// ϥɥƤӽФΥ桼å
	*(uint*) KERNEL_USER_ESP = DRIVER_ESP_BEG;

	setDevIntrHandler(i_irq, doUserIntrHandler);
}

/*
 * ͥߥϥɥ򥻥åȤ
 */
void setKernIntrHandler(
	const int i_irq)
{
	ASSERT((0 <= i_irq) & (i_irq <= IRQ_ENTRY));

	setDevIntrHandler(i_irq, doKernIntrHandler);
}

//*************************************************************************************************

#ifdef DEBUG
void testDevInterrupt(
	const int irq,
	const int plus,
	const uint eip)
{
	static int irqs = 0;
	static int count = 0;

	if (irq == 0) {
		if (plus == 1) {
			printDebug(80 * 10 + 60, "0-%x-%x   ", eip, getCurrentTask());
		}
		else {
			printDebug(80 * 10 + 60, "                    ");
		}
	}
	if (irq == 8) {
		if (plus == 1) {
			printDebug(80 * 11 + 60, "8-%x-%x   ", eip, getCurrentTask());
		}
		else {
			printDebug(80 * 11 + 60, "                    ");
		}
	}
	if (irq == 14) {
		if (plus == 1) {
			printDebug(80 * 12 + 60, "14-%x-%x   ", eip, getCurrentTask());
		}
		else {
			printDebug(80 * 12 + 60, "                    ");
		}
	}
	if (irq == 16) {
		if (plus == 1) {
			printDebug(80 * 13 + 60, "16-%x-%x   ", eip, getCurrentTask());
		}
		else {
			printDebug(80 * 13 + 60, "                    ");
		}
	}
	if (irq == 17) {
		if (plus == 1) {
			printDebug(80 * 14 + 60, "17-%x-%x   ", eip, getCurrentTask());
		}
		else {
			printDebug(80 * 14 + 60, "                    ");
		}
	}
}
#endif
