/*
 * DevInterrupt.h
 *
 * Copyright 2008, Minoru Murashima. All rights reserved.
 * Distributed under the terms of the BSD License.
 */


#ifndef i386_DevInterrupt_h
#define i386_DevInterrupt_h


#include <i386/syscall.h>


#ifndef ASM_FILE


enum {
	// IRQȥ꡼ơ֥
	IRQ0			= 0,
	IRQ1			= 1,
	IRQ3			= 3,
	IRQ4			= 4,
	IRQ5			= 5,
	IRQ6			= 6,
	IRQ7			= 7,
	IRQ8			= 8,
	IRQ9			= 9,
	IRQ10			= 10,
	IRQ11			= 11,
	IRQ12			= 12,
	IRQ13			= 13,
	IRQ14			= 14,
	IRQ15			= 15,
	APIC_TIMER		= 16,
	FLASH_PAGEDIR	= 17,
	IRQ18			= 18,
	IRQ19			= 19,
	IRQ_ENTRY		= 20,	// IRQϥɥ饨ȥ꡼
};

extern int (*irq_entry[])(int);
extern void (*release_irq_mask)(uchar);
extern void (*set_irq_mask)(uchar);
extern void (*irq_eoi)(uchar);
extern void *changeIntrTask();
extern void *endIntrTask();
extern void setUserIntrHandler(const int);
extern void setKernIntrHandler(const int);


#endif


#endif
